/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncaughtExceptionsRule
implements TestRule {
    private Thread.UncaughtExceptionHandler savedUncaughtExceptionHandler;
    private final LuceneTestCase ltc;
    private final List<UncaughtExceptionEntry> uncaughtExceptions = new ArrayList<UncaughtExceptionEntry>();

    public UncaughtExceptionsRule(LuceneTestCase ltc) {
        this.ltc = ltc;
    }

    public Statement apply(final Statement s, Description d) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    UncaughtExceptionsRule.this.setupHandler();
                    s.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    UncaughtExceptionsRule.this.restoreHandler();
                }
                List list = UncaughtExceptionsRule.this.uncaughtExceptions;
                synchronized (list) {
                    for (UncaughtExceptionEntry e : UncaughtExceptionsRule.this.uncaughtExceptions) {
                        errors.add(new UncaughtExceptionsInBackgroundThread(e));
                    }
                    UncaughtExceptionsRule.this.uncaughtExceptions.clear();
                }
                if (UncaughtExceptionsRule.this.hasNonAssumptionErrors(errors)) {
                    if (UncaughtExceptionsRule.this.ltc == null) {
                        LuceneTestCase.reportPartialFailureInfo();
                    } else {
                        UncaughtExceptionsRule.this.ltc.reportAdditionalFailureInfo();
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private boolean hasNonAssumptionErrors(ArrayList<Throwable> errors) {
        for (Throwable t : errors) {
            if (t instanceof AssumptionViolatedException) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUncaughtExceptions() {
        List<UncaughtExceptionEntry> list = this.uncaughtExceptions;
        synchronized (list) {
            return !this.uncaughtExceptions.isEmpty();
        }
    }

    private void restoreHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.savedUncaughtExceptionHandler);
    }

    private void setupHandler() {
        this.savedUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void uncaughtException(Thread t, Throwable e) {
                if (e.getClass().getName().endsWith("AssumptionViolatedException")) {
                    String where = "<unknown>";
                    for (StackTraceElement elem : e.getStackTrace()) {
                        if (elem.getClassName().startsWith("org.junit")) continue;
                        where = elem.toString();
                        break;
                    }
                    System.err.print("NOTE: Uncaught exception handler caught a failed assumption at " + where + " (ignored):");
                } else {
                    List where = UncaughtExceptionsRule.this.uncaughtExceptions;
                    synchronized (where) {
                        UncaughtExceptionsRule.this.uncaughtExceptions.add(new UncaughtExceptionEntry(t, e));
                    }
                    StringWriter sw = new StringWriter();
                    sw.write("\n===>\nUncaught exception by thread: " + t + "\n");
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    sw.write("<===\n");
                    System.err.println(sw.toString());
                }
            }
        });
    }

    private static class UncaughtExceptionsInBackgroundThread
    extends RuntimeException {
        public UncaughtExceptionsInBackgroundThread(UncaughtExceptionEntry e) {
            super("Uncaught exception by thread: " + e.thread, e.exception);
        }
    }

    public static class UncaughtExceptionEntry {
        public final Thread thread;
        public final Throwable exception;

        public UncaughtExceptionEntry(Thread thread, Throwable exception) {
            this.thread = thread;
            this.exception = exception;
        }
    }
}

