/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.LineFileDocs;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util._TestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThreadedIndexingAndSearchingTestCase
extends LuceneTestCase {
    protected final AtomicBoolean failed = new AtomicBoolean();
    protected final AtomicInteger addCount = new AtomicInteger();
    protected final AtomicInteger delCount = new AtomicInteger();
    protected final AtomicInteger packCount = new AtomicInteger();
    protected Directory dir;
    protected IndexWriter writer;

    protected abstract IndexSearcher getCurrentSearcher() throws Exception;

    protected abstract IndexSearcher getFinalSearcher() throws Exception;

    protected void releaseSearcher(IndexSearcher s) throws Exception {
    }

    protected abstract void doSearching(ExecutorService var1, long var2) throws Exception;

    protected Directory getDirectory(Directory in) {
        return in;
    }

    protected void updateDocuments(Term id, Collection<Document> docs) throws Exception {
        this.writer.updateDocuments(id, docs);
    }

    protected void addDocuments(Term id, Collection<Document> docs) throws Exception {
        this.writer.addDocuments(docs);
    }

    protected void addDocument(Term id, Document doc) throws Exception {
        this.writer.addDocument(doc);
    }

    protected void updateDocument(Term term, Document doc) throws Exception {
        this.writer.updateDocument(term, doc);
    }

    protected void deleteDocuments(Term term) throws Exception {
        this.writer.deleteDocuments(term);
    }

    protected void doAfterIndexingThreadDone() {
    }

    private Thread[] launchIndexingThreads(final LineFileDocs docs, int numThreads, final long stopTime, final Set<String> delIDs, final Set<String> delPackIDs, final List<SubDocs> allSubDocs) throws Exception {
        Thread[] threads = new Thread[numThreads];
        for (int thread = 0; thread < numThreads; ++thread) {
            threads[thread] = new Thread(){

                public void run() {
                    ArrayList<String> toDeleteIDs = new ArrayList<String>();
                    ArrayList<SubDocs> toDeleteSubDocs = new ArrayList<SubDocs>();
                    while (System.currentTimeMillis() < stopTime && !ThreadedIndexingAndSearchingTestCase.this.failed.get()) {
                        try {
                            String docid;
                            String addedField;
                            Document doc;
                            if (LuceneTestCase.TEST_NIGHTLY && random.nextInt(6) == 3) {
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": now long sleep");
                                }
                                Thread.sleep(_TestUtil.nextInt(random, 50, 500));
                            }
                            if (random.nextInt(7) == 5) {
                                Thread.sleep(_TestUtil.nextInt(random, 1, 10));
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": done sleep");
                                }
                            }
                            if ((doc = docs.nextDoc()) == null) break;
                            if (random.nextBoolean()) {
                                addedField = "extra" + random.nextInt(40);
                                doc.add((Fieldable)LuceneTestCase.newField(addedField, "a random field", Field.Store.YES, Field.Index.ANALYZED));
                            } else {
                                addedField = null;
                            }
                            if (random.nextBoolean()) {
                                if (random.nextBoolean()) {
                                    String packID;
                                    SubDocs delSubDocs;
                                    if (toDeleteSubDocs.size() > 0 && random.nextBoolean()) {
                                        delSubDocs = (SubDocs)toDeleteSubDocs.get(random.nextInt(toDeleteSubDocs.size()));
                                        assert (!delSubDocs.deleted);
                                        toDeleteSubDocs.remove(delSubDocs);
                                        packID = delSubDocs.packID;
                                    } else {
                                        delSubDocs = null;
                                        packID = ThreadedIndexingAndSearchingTestCase.this.packCount.getAndIncrement() + "";
                                    }
                                    Field packIDField = LuceneTestCase.newField("packID", packID, Field.Store.YES, Field.Index.NOT_ANALYZED);
                                    ArrayList<String> docIDs = new ArrayList<String>();
                                    SubDocs subDocs = new SubDocs(packID, docIDs);
                                    ArrayList<Document> docsList = new ArrayList<Document>();
                                    allSubDocs.add(subDocs);
                                    doc.add((Fieldable)packIDField);
                                    docsList.add(_TestUtil.cloneDocument(doc));
                                    docIDs.add(doc.get("docid"));
                                    int maxDocCount = _TestUtil.nextInt(random, 1, 10);
                                    while (docsList.size() < maxDocCount && (doc = docs.nextDoc()) != null) {
                                        docsList.add(_TestUtil.cloneDocument(doc));
                                        docIDs.add(doc.get("docid"));
                                    }
                                    ThreadedIndexingAndSearchingTestCase.this.addCount.addAndGet(docsList.size());
                                    Term packIDTerm = new Term("packID", packID);
                                    if (delSubDocs != null) {
                                        delSubDocs.deleted = true;
                                        delIDs.addAll(delSubDocs.subIDs);
                                        ThreadedIndexingAndSearchingTestCase.this.delCount.addAndGet(delSubDocs.subIDs.size());
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": update pack packID=" + delSubDocs.packID + " count=" + docsList.size() + " docs=" + docIDs);
                                        }
                                        ThreadedIndexingAndSearchingTestCase.this.updateDocuments(packIDTerm, docsList);
                                    } else {
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": add pack packID=" + packID + " count=" + docsList.size() + " docs=" + docIDs);
                                        }
                                        ThreadedIndexingAndSearchingTestCase.this.addDocuments(packIDTerm, docsList);
                                    }
                                    doc.removeField("packID");
                                    if (random.nextInt(5) == 2) {
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": buffer del id:" + packID);
                                        }
                                        toDeleteSubDocs.add(subDocs);
                                    }
                                } else {
                                    docid = doc.get("docid");
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": add doc docid:" + docid);
                                    }
                                    ThreadedIndexingAndSearchingTestCase.this.addDocument(new Term("docid", docid), doc);
                                    ThreadedIndexingAndSearchingTestCase.this.addCount.getAndIncrement();
                                    if (random.nextInt(5) == 3) {
                                        if (LuceneTestCase.VERBOSE) {
                                            System.out.println(Thread.currentThread().getName() + ": buffer del id:" + doc.get("docid"));
                                        }
                                        toDeleteIDs.add(docid);
                                    }
                                }
                            } else {
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": update doc id:" + doc.get("docid"));
                                }
                                docid = doc.get("docid");
                                ThreadedIndexingAndSearchingTestCase.this.updateDocument(new Term("docid", docid), doc);
                                ThreadedIndexingAndSearchingTestCase.this.addCount.getAndIncrement();
                                if (random.nextInt(5) == 3) {
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": buffer del id:" + doc.get("docid"));
                                    }
                                    toDeleteIDs.add(docid);
                                }
                            }
                            if (random.nextInt(30) == 17) {
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": apply " + toDeleteIDs.size() + " deletes");
                                }
                                for (String id : toDeleteIDs) {
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": del term=id:" + id);
                                    }
                                    ThreadedIndexingAndSearchingTestCase.this.deleteDocuments(new Term("docid", id));
                                }
                                int count = ThreadedIndexingAndSearchingTestCase.this.delCount.addAndGet(toDeleteIDs.size());
                                if (LuceneTestCase.VERBOSE) {
                                    System.out.println(Thread.currentThread().getName() + ": tot " + count + " deletes");
                                }
                                delIDs.addAll(toDeleteIDs);
                                toDeleteIDs.clear();
                                for (SubDocs subDocs : toDeleteSubDocs) {
                                    assert (!subDocs.deleted);
                                    delPackIDs.add(subDocs.packID);
                                    ThreadedIndexingAndSearchingTestCase.this.deleteDocuments(new Term("packID", subDocs.packID));
                                    subDocs.deleted = true;
                                    if (LuceneTestCase.VERBOSE) {
                                        System.out.println(Thread.currentThread().getName() + ": del subs: " + subDocs.subIDs + " packID=" + subDocs.packID);
                                    }
                                    delIDs.addAll(subDocs.subIDs);
                                    ThreadedIndexingAndSearchingTestCase.this.delCount.addAndGet(subDocs.subIDs.size());
                                }
                                toDeleteSubDocs.clear();
                            }
                            if (addedField == null) continue;
                            doc.removeField(addedField);
                        }
                        catch (Throwable t) {
                            System.out.println(Thread.currentThread().getName() + ": hit exc");
                            t.printStackTrace();
                            ThreadedIndexingAndSearchingTestCase.this.failed.set(true);
                            throw new RuntimeException(t);
                        }
                    }
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println(Thread.currentThread().getName() + ": indexing done");
                    }
                    ThreadedIndexingAndSearchingTestCase.this.doAfterIndexingThreadDone();
                }
            };
            threads[thread].setDaemon(true);
            threads[thread].start();
        }
        return threads;
    }

    protected void runSearchThreads(final long stopTimeMS) throws Exception {
        int thread;
        int numThreads = _TestUtil.nextInt(random, 1, 5);
        Thread[] searchThreads = new Thread[numThreads];
        final AtomicInteger totHits = new AtomicInteger();
        final AtomicInteger totTermCount = new AtomicInteger(100);
        for (thread = 0; thread < searchThreads.length; ++thread) {
            searchThreads[thread] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block5: while (System.currentTimeMillis() < stopTimeMS) {
                        try {
                            IndexSearcher s = ThreadedIndexingAndSearchingTestCase.this.getCurrentSearcher();
                            try {
                                int trigger;
                                int shift;
                                if (s.getIndexReader().numDocs() <= 0) continue;
                                ThreadedIndexingAndSearchingTestCase.this.smokeTestSearcher(s);
                                TermEnum termEnum = s.getIndexReader().terms(new Term("body", ""));
                                int seenTermCount = 0;
                                if (totTermCount.get() < 10) {
                                    shift = 0;
                                    trigger = 1;
                                } else {
                                    trigger = totTermCount.get() / 10;
                                    shift = random.nextInt(trigger);
                                }
                                while (System.currentTimeMillis() < stopTimeMS) {
                                    Term term = termEnum.term();
                                    if (term == null) {
                                        if (seenTermCount == 0) continue block5;
                                        totTermCount.set(seenTermCount);
                                        seenTermCount = 0;
                                        if (totTermCount.get() < 10) {
                                            shift = 0;
                                            trigger = 1;
                                        } else {
                                            trigger = totTermCount.get() / 10;
                                            shift = random.nextInt(trigger);
                                        }
                                        termEnum = s.getIndexReader().terms(new Term("body", ""));
                                        continue;
                                    }
                                    ++seenTermCount;
                                    if (trigger == 0) {
                                        trigger = 1;
                                    }
                                    if ((seenTermCount + shift) % trigger != 0) continue;
                                    totHits.addAndGet(ThreadedIndexingAndSearchingTestCase.this.runQuery(s, (Query)new TermQuery(term)));
                                }
                            }
                            finally {
                                ThreadedIndexingAndSearchingTestCase.this.releaseSearcher(s);
                            }
                        }
                        catch (Throwable t) {
                            System.out.println(Thread.currentThread().getName() + ": hit exc");
                            ThreadedIndexingAndSearchingTestCase.this.failed.set(true);
                            t.printStackTrace(System.out);
                            throw new RuntimeException(t);
                        }
                    }
                }
            };
            searchThreads[thread].setDaemon(true);
            searchThreads[thread].start();
        }
        for (thread = 0; thread < searchThreads.length; ++thread) {
            searchThreads[thread].join();
        }
        if (VERBOSE) {
            System.out.println("TEST: DONE search: totHits=" + totHits);
        }
    }

    protected void doAfterWriter(ExecutorService es) throws Exception {
    }

    protected void doClose() throws Exception {
    }

    public void runTest(String testName) throws Exception {
        TopDocs hits;
        this.failed.set(false);
        this.addCount.set(0);
        this.delCount.set(0);
        this.packCount.set(0);
        long t0 = System.currentTimeMillis();
        LineFileDocs docs = new LineFileDocs(random);
        File tempDir = _TestUtil.getTempDir(testName);
        this.dir = ThreadedIndexingAndSearchingTestCase.newFSDirectory(tempDir);
        ((MockDirectoryWrapper)this.dir).setCheckIndexOnClose(false);
        IndexWriterConfig conf = ThreadedIndexingAndSearchingTestCase.newIndexWriterConfig(TEST_VERSION_CURRENT, new MockAnalyzer(random));
        if (LuceneTestCase.TEST_NIGHTLY) {
            MergePolicy mp = conf.getMergePolicy();
            if (mp instanceof TieredMergePolicy) {
                ((TieredMergePolicy)mp).setMaxMergedSegmentMB(5000.0);
            } else if (mp instanceof LogByteSizeMergePolicy) {
                ((LogByteSizeMergePolicy)mp).setMaxMergeMB(1000.0);
            } else if (mp instanceof LogMergePolicy) {
                ((LogMergePolicy)mp).setMaxMergeDocs(100000);
            }
        }
        conf.setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

            public void warm(IndexReader reader) throws IOException {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: now warm merged reader=" + reader);
                }
                int maxDoc = reader.maxDoc();
                int sum = 0;
                int inc = Math.max(1, maxDoc / 50);
                for (int docID = 0; docID < maxDoc; docID += inc) {
                    if (reader.isDeleted(docID)) continue;
                    Document doc = reader.document(docID);
                    sum += doc.getFields().size();
                }
                IndexSearcher searcher = LuceneTestCase.newSearcher(reader);
                sum += searcher.search((Query)new TermQuery((Term)new Term((String)"body", (String)"united")), (int)10).totalHits;
                searcher.close();
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: warm visited " + sum + " fields");
                }
            }
        });
        this.writer = new IndexWriter(this.dir, conf);
        if (VERBOSE) {
            this.writer.setInfoStream(System.out);
        }
        _TestUtil.reduceOpenFiles(this.writer);
        ExecutorService es = random.nextBoolean() ? null : Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory(testName));
        this.doAfterWriter(es);
        int NUM_INDEX_THREADS = _TestUtil.nextInt(random, 2, 4);
        int RUN_TIME_SEC = LuceneTestCase.TEST_NIGHTLY ? 300 : RANDOM_MULTIPLIER;
        Set<String> delIDs = Collections.synchronizedSet(new HashSet());
        Set<String> delPackIDs = Collections.synchronizedSet(new HashSet());
        List<SubDocs> allSubDocs = Collections.synchronizedList(new ArrayList());
        long stopTime = System.currentTimeMillis() + (long)(RUN_TIME_SEC * 1000);
        Thread[] indexThreads = this.launchIndexingThreads(docs, NUM_INDEX_THREADS, stopTime, delIDs, delPackIDs, allSubDocs);
        if (VERBOSE) {
            System.out.println("TEST: DONE start indexing threads [" + (System.currentTimeMillis() - t0) + " ms]");
        }
        Thread.sleep(100L);
        this.doSearching(es, stopTime);
        if (VERBOSE) {
            System.out.println("TEST: all searching done [" + (System.currentTimeMillis() - t0) + " ms]");
        }
        for (int thread = 0; thread < indexThreads.length; ++thread) {
            indexThreads[thread].join();
        }
        if (VERBOSE) {
            System.out.println("TEST: done join indexing threads [" + (System.currentTimeMillis() - t0) + " ms]; addCount=" + this.addCount + " delCount=" + this.delCount);
        }
        IndexSearcher s = this.getFinalSearcher();
        if (VERBOSE) {
            System.out.println("TEST: finalSearcher=" + s);
        }
        ThreadedIndexingAndSearchingTestCase.assertFalse((boolean)this.failed.get());
        boolean doFail = false;
        for (String id : delIDs) {
            hits = s.search((Query)new TermQuery(new Term("docid", id)), 1);
            if (hits.totalHits == 0) continue;
            System.out.println("doc id=" + id + " is supposed to be deleted, but got " + hits.totalHits + " hits; first docID=" + hits.scoreDocs[0].doc);
            doFail = true;
        }
        for (String id : delPackIDs) {
            hits = s.search((Query)new TermQuery(new Term("packID", id)), 1);
            if (hits.totalHits == 0) continue;
            System.out.println("packID=" + id + " is supposed to be deleted, but got " + hits.totalHits + " matches");
            doFail = true;
        }
        for (SubDocs subDocs : allSubDocs) {
            hits = s.search((Query)new TermQuery(new Term("packID", subDocs.packID)), 20);
            if (!subDocs.deleted) {
                if (hits.totalHits != subDocs.subIDs.size()) {
                    System.out.println("packID=" + subDocs.packID + ": expected " + subDocs.subIDs.size() + " hits but got " + hits.totalHits);
                    doFail = true;
                    continue;
                }
                int lastDocID = -1;
                int startDocID = -1;
                for (ScoreDoc scoreDoc : hits.scoreDocs) {
                    int docID = scoreDoc.doc;
                    if (lastDocID != -1) {
                        ThreadedIndexingAndSearchingTestCase.assertEquals((long)(1 + lastDocID), (long)docID);
                    } else {
                        startDocID = docID;
                    }
                    lastDocID = docID;
                    Document doc = s.doc(docID);
                    ThreadedIndexingAndSearchingTestCase.assertEquals((Object)subDocs.packID, (Object)doc.get("packID"));
                }
                lastDocID = startDocID - 1;
                for (String subID : subDocs.subIDs) {
                    hits = s.search((Query)new TermQuery(new Term("docid", subID)), 1);
                    ThreadedIndexingAndSearchingTestCase.assertEquals((long)1L, (long)hits.totalHits);
                    int docID = hits.scoreDocs[0].doc;
                    if (lastDocID != -1) {
                        ThreadedIndexingAndSearchingTestCase.assertEquals((long)(1 + lastDocID), (long)docID);
                    }
                    lastDocID = docID;
                }
                continue;
            }
            for (String subID : subDocs.subIDs) {
                ThreadedIndexingAndSearchingTestCase.assertEquals((long)0L, (long)s.search((Query)new TermQuery((Term)new Term((String)"docid", (String)subID)), (int)1).totalHits);
            }
        }
        int endID = Integer.parseInt(docs.nextDoc().get("docid"));
        docs.close();
        for (int id = 0; id < endID; ++id) {
            String stringID = "" + id;
            if (delIDs.contains(stringID)) continue;
            TopDocs hits2 = s.search((Query)new TermQuery(new Term("docid", stringID)), 1);
            if (hits2.totalHits == 1) continue;
            System.out.println("doc id=" + stringID + " is not supposed to be deleted, but got hitCount=" + hits2.totalHits);
            doFail = true;
        }
        ThreadedIndexingAndSearchingTestCase.assertFalse((boolean)doFail);
        ThreadedIndexingAndSearchingTestCase.assertEquals((String)("index=" + this.writer.segString() + " addCount=" + this.addCount + " delCount=" + this.delCount), (long)(this.addCount.get() - this.delCount.get()), (long)s.getIndexReader().numDocs());
        this.releaseSearcher(s);
        this.writer.commit();
        ThreadedIndexingAndSearchingTestCase.assertEquals((String)("index=" + this.writer.segString() + " addCount=" + this.addCount + " delCount=" + this.delCount), (long)(this.addCount.get() - this.delCount.get()), (long)this.writer.numDocs());
        ThreadedIndexingAndSearchingTestCase.assertFalse((boolean)this.writer.anyNonBulkMerges);
        this.doClose();
        this.writer.close(false);
        if (es != null) {
            es.shutdown();
            es.awaitTermination(1L, TimeUnit.SECONDS);
        }
        _TestUtil.checkIndex(this.dir);
        this.dir.close();
        _TestUtil.rmDir(tempDir);
        if (VERBOSE) {
            System.out.println("TEST: done [" + (System.currentTimeMillis() - t0) + " ms]");
        }
    }

    private int runQuery(IndexSearcher s, Query q) throws Exception {
        s.search(q, 10);
        return s.search((Query)q, null, (int)10, (Sort)new Sort((SortField)new SortField((String)"title", (int)3))).totalHits;
    }

    protected void smokeTestSearcher(IndexSearcher s) throws Exception {
        this.runQuery(s, (Query)new TermQuery(new Term("body", "united")));
        this.runQuery(s, (Query)new TermQuery(new Term("titleTokenized", "states")));
        PhraseQuery pq = new PhraseQuery();
        pq.add(new Term("body", "united"));
        pq.add(new Term("body", "states"));
        this.runQuery(s, (Query)pq);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubDocs {
        public final String packID;
        public final List<String> subIDs;
        public boolean deleted;

        public SubDocs(String packID, List<String> subIDs) {
            this.packID = packID;
            this.subIDs = subIDs;
        }
    }
}

