/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class AssertingIndexSearcher
extends IndexSearcher {
    public AssertingIndexSearcher(IndexReader r) {
        super(r);
    }

    public AssertingIndexSearcher(IndexReader r, ExecutorService ex) {
        super(r, ex);
    }

    public Weight createNormalizedWeight(Query query) throws IOException {
        Weight w = super.createNormalizedWeight(query);
        return new UnmodifiableWeight(w);
    }

    private static final class UnmodifiableWeight
    extends Weight {
        private final Weight w;

        UnmodifiableWeight(Weight w) {
            this.w = w;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.w.explain(reader, doc);
        }

        public Query getQuery() {
            return this.w.getQuery();
        }

        public float getValue() {
            return this.w.getValue();
        }

        public void normalize(float norm) {
            throw new IllegalStateException("Weight already normalized.");
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return this.w.scorer(reader, scoreDocsInOrder, topScorer);
        }

        public float sumOfSquaredWeights() throws IOException {
            throw new IllegalStateException("Weight already normalized.");
        }

        public boolean scoresDocsOutOfOrder() {
            return this.w.scoresDocsOutOfOrder();
        }
    }
}

