/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Version;
import org.apache.lucene.util._TestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomIndexWriter
implements Closeable {
    public IndexWriter w;
    private final Random r;
    int docCount;
    int flushAt;
    private double flushAtFactor = 1.0;
    private boolean getReaderCalled;

    public RandomIndexWriter(Random r, Directory dir) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, new MockAnalyzer(r)));
    }

    public RandomIndexWriter(Random r, Directory dir, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, LuceneTestCase.TEST_VERSION_CURRENT, a));
    }

    public RandomIndexWriter(Random r, Directory dir, Version v, Analyzer a) throws IOException {
        this(r, dir, LuceneTestCase.newIndexWriterConfig(r, v, a));
    }

    public RandomIndexWriter(Random r, Directory dir, IndexWriterConfig c) throws IOException {
        this.r = r;
        this.w = new MockIndexWriter(r, dir, c);
        this.flushAt = _TestUtil.nextInt(r, 10, 1000);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW config=" + this.w.getConfig());
        }
    }

    public void addDocument(Document doc) throws IOException {
        if (this.r.nextInt(5) == 3) {
            this.w.addDocuments(Collections.singletonList(doc));
        } else {
            this.w.addDocument(doc);
        }
        this.maybeCommit();
    }

    public void addDocuments(Collection<Document> docs) throws IOException {
        this.w.addDocuments(docs);
        this.maybeCommit();
    }

    public void updateDocuments(Term delTerm, Collection<Document> docs) throws IOException {
        this.w.updateDocuments(delTerm, docs);
        this.maybeCommit();
    }

    private void maybeCommit() throws IOException {
        if (this.docCount++ == this.flushAt) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.add/updateDocument: now doing a commit at docCount=" + this.docCount);
            }
            this.w.commit();
            this.flushAt += _TestUtil.nextInt(this.r, (int)(this.flushAtFactor * 10.0), (int)(this.flushAtFactor * 1000.0));
            if (this.flushAtFactor < 2000000.0) {
                this.flushAtFactor *= 1.05;
            }
        }
    }

    public void updateDocument(Term t, Document doc) throws IOException {
        if (this.r.nextInt(5) == 3) {
            this.w.updateDocuments(t, Collections.singletonList(doc));
        } else {
            this.w.updateDocument(t, doc);
        }
        this.maybeCommit();
    }

    public void addIndexes(Directory ... dirs) throws CorruptIndexException, IOException {
        this.w.addIndexes(dirs);
    }

    public void deleteDocuments(Term term) throws CorruptIndexException, IOException {
        this.w.deleteDocuments(term);
    }

    public void commit() throws CorruptIndexException, IOException {
        this.w.commit();
    }

    public int numDocs() throws IOException {
        return this.w.numDocs();
    }

    public int maxDoc() {
        return this.w.maxDoc();
    }

    public void deleteAll() throws IOException {
        this.w.deleteAll();
    }

    private void doRandomOptimize() throws IOException {
        int segCount = this.w.getSegmentCount();
        if (this.r.nextBoolean() || segCount == 0) {
            this.w.optimize();
        } else {
            int limit = _TestUtil.nextInt(this.r, 1, segCount);
            this.w.optimize(limit);
            assert (this.w.getSegmentCount() <= limit) : "limit=" + limit + " actual=" + this.w.getSegmentCount();
        }
    }

    public IndexReader getReader() throws IOException {
        return this.getReader(true);
    }

    public IndexReader getReader(boolean applyDeletions) throws IOException {
        this.getReaderCalled = true;
        if (this.r.nextInt(4) == 2) {
            this.doRandomOptimize();
        }
        if (this.r.nextBoolean()) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("RIW.getReader: use NRT reader");
            }
            return this.w.getReader(applyDeletions);
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("RIW.getReader: open new reader");
        }
        this.w.commit();
        return IndexReader.open((Directory)this.w.getDirectory(), (IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy(), (boolean)this.r.nextBoolean(), (int)_TestUtil.nextInt(this.r, 1, 10));
    }

    @Override
    public void close() throws IOException {
        if (!this.getReaderCalled && this.r.nextInt(4) == 2) {
            this.doRandomOptimize();
        }
        this.w.close();
    }

    public void optimize() throws IOException {
        this.w.optimize();
    }

    private static final class MockIndexWriter
    extends IndexWriter {
        private final Random r;

        public MockIndexWriter(Random r, Directory dir, IndexWriterConfig conf) throws IOException {
            super(dir, conf);
            this.r = new Random(r.nextInt());
        }

        boolean testPoint(String name) {
            if (this.r.nextInt(4) == 2) {
                Thread.yield();
            }
            return true;
        }
    }
}

