/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.util.LuceneTestCase;

public class LineFileDocs
implements Closeable {
    private BufferedReader reader;
    private static final int BUFFER_SIZE = 65536;
    private final AtomicInteger id = new AtomicInteger();
    private final String path;
    private static final char SEP = '\t';
    private final ThreadLocal<DocState> threadDocs = new ThreadLocal();

    public LineFileDocs(Random random, String path) throws IOException {
        this.path = path;
        this.open(random);
    }

    public LineFileDocs(Random random) throws IOException {
        this(random, LuceneTestCase.TEST_LINE_DOCS_FILE);
    }

    public synchronized void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private synchronized void open(Random random) throws IOException {
        File file;
        InputStream is = this.getClass().getResourceAsStream(this.path);
        if (is == null) {
            is = new FileInputStream(this.path);
        }
        long size = (file = new File(this.path)).exists() ? file.length() : (long)is.available();
        if (this.path.endsWith(".gz")) {
            is = new GZIPInputStream(is);
            size = (long)((double)size * 2.8);
        }
        BufferedInputStream in = new BufferedInputStream(is, 65536);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"), 65536);
        if (this.path.equals("europarl.lines.txt.gz")) {
            size = 15129506L;
        } else if (this.path.equals("/home/hudson/lucene-data/enwiki.random.lines.txt.gz")) {
            size = 3038178822L;
        }
        if (random != null && size > 3L) {
            long seekTo = (random.nextLong() & Long.MAX_VALUE) % (size / 3L);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: LineFileDocs: seek to fp=" + seekTo + " on open");
            }
            this.reader.skip(seekTo);
            this.reader.readLine();
        }
    }

    public synchronized void reset(Random random) throws IOException {
        this.close();
        this.open(random);
        this.id.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document nextDoc() throws IOException {
        int spot;
        String line;
        LineFileDocs lineFileDocs = this;
        synchronized (lineFileDocs) {
            line = this.reader.readLine();
            if (line == null) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("TEST: LineFileDocs: now rewind file...");
                }
                this.close();
                this.open(null);
                line = this.reader.readLine();
            }
        }
        DocState docState = this.threadDocs.get();
        if (docState == null) {
            docState = new DocState();
            this.threadDocs.set(docState);
        }
        if ((spot = line.indexOf(9)) == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        int spot2 = line.indexOf(9, 1 + spot);
        if (spot2 == -1) {
            throw new RuntimeException("line: [" + line + "] is in an invalid format !");
        }
        docState.body.setValue(line.substring(1 + spot2, line.length()));
        String title = line.substring(0, spot);
        docState.title.setValue(title);
        docState.titleTokenized.setValue(title);
        docState.date.setValue(line.substring(1 + spot, spot2));
        docState.id.setValue(Integer.toString(this.id.getAndIncrement()));
        return docState.doc;
    }

    private static final class DocState {
        final Document doc = new Document();
        final Field titleTokenized;
        final Field title = new Field("title", "", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
        final Field body;
        final Field id;
        final Field date;

        public DocState() {
            this.doc.add((Fieldable)this.title);
            this.titleTokenized = new Field("titleTokenized", "", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS);
            this.doc.add((Fieldable)this.titleTokenized);
            this.body = new Field("body", "", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS);
            this.doc.add((Fieldable)this.body);
            this.id = new Field("id", "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
            this.doc.add((Fieldable)this.id);
            this.date = new Field("date", "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
            this.doc.add((Fieldable)this.date);
        }
    }
}

