/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordTokenizer;
import org.apache.lucene.analysis.LetterTokenizer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.SimplePayloadFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.util.LuceneTestCase;

public final class MockAnalyzer
extends Analyzer {
    private boolean lowerCase;
    private boolean payloads;
    public static final int KEYWORD = 0;
    public static final int WHITESPACE = 1;
    public static final int SIMPLE = 2;
    private int tokenizer;

    public MockAnalyzer() {
        this(1, true);
    }

    public MockAnalyzer(int tokenizer, boolean lowercase) {
        this(tokenizer, lowercase, true);
    }

    public MockAnalyzer(int tokenizer, boolean lowercase, boolean payloads) {
        this.tokenizer = tokenizer;
        this.lowerCase = lowercase;
        this.payloads = payloads;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = this.tokenizer == 0 ? new KeywordTokenizer(reader) : (this.tokenizer == 2 ? new LetterTokenizer(LuceneTestCase.TEST_VERSION_CURRENT, reader) : new WhitespaceTokenizer(LuceneTestCase.TEST_VERSION_CURRENT, reader));
        if (this.lowerCase) {
            result = new LowerCaseFilter(LuceneTestCase.TEST_VERSION_CURRENT, (TokenStream)result);
        }
        if (this.payloads) {
            result = new SimplePayloadFilter((TokenStream)result, fieldName);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams saved = (SavedStreams)this.getPreviousTokenStream();
        if (saved == null) {
            saved = new SavedStreams();
            saved.upstream = this.tokenizer == 0 ? new KeywordTokenizer(reader) : (this.tokenizer == 2 ? new LetterTokenizer(LuceneTestCase.TEST_VERSION_CURRENT, reader) : new WhitespaceTokenizer(LuceneTestCase.TEST_VERSION_CURRENT, reader));
            saved.filter = saved.upstream;
            if (this.lowerCase) {
                saved.filter = new LowerCaseFilter(LuceneTestCase.TEST_VERSION_CURRENT, saved.filter);
            }
            if (this.payloads) {
                saved.filter = new SimplePayloadFilter(saved.filter, fieldName);
            }
            this.setPreviousTokenStream(saved);
            return saved.filter;
        }
        saved.upstream.reset(reader);
        saved.filter.reset();
        return saved.filter;
    }

    private class SavedStreams {
        Tokenizer upstream;
        TokenStream filter;

        private SavedStreams() {
        }
    }
}

