/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.swing.models;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public class ListSearcher
extends AbstractListModel {
    private ListModel listModel;
    private ArrayList<Integer> rowToModelIndex = new ArrayList();
    private RAMDirectory directory;
    private Analyzer analyzer = new WhitespaceAnalyzer();
    private static final String ROW_NUMBER = "ROW_NUMBER";
    private static final String FIELD_NAME = "FIELD_NAME";
    private String searchString = null;
    private ListDataListener listModelListener;

    public ListSearcher(ListModel newModel) {
        this.setListModel(newModel);
        this.listModelListener = new ListModelHandler();
        newModel.addListDataListener(this.listModelListener);
        this.clearSearchingState();
    }

    private void setListModel(ListModel newModel) {
        if (newModel != null) {
            newModel.removeListDataListener(this.listModelListener);
        }
        this.listModel = newModel;
        if (this.listModel != null) {
            this.listModel.addListDataListener(this.listModelListener);
        }
        this.reindex();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private void reindex() {
        try {
            this.directory = new RAMDirectory();
            IndexWriter writer = new IndexWriter((Directory)this.directory, this.analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
            for (int row = 0; row < this.listModel.getSize(); ++row) {
                Document document = new Document();
                document.add((Fieldable)new Field(ROW_NUMBER, "" + row, Field.Store.YES, Field.Index.ANALYZED));
                document.add((Fieldable)new Field(FIELD_NAME, String.valueOf(this.listModel.getElementAt(row)).toLowerCase(), Field.Store.YES, Field.Index.ANALYZED));
                writer.addDocument(document);
            }
            writer.optimize();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void search(String searchString) {
        if (searchString == null || searchString.equals("")) {
            this.clearSearchingState();
            this.fireContentsChanged(this, 0, this.getSize());
            return;
        }
        try {
            this.searchString = searchString;
            IndexSearcher is = new IndexSearcher((Directory)this.directory, true);
            String[] fields = new String[]{FIELD_NAME};
            MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_CURRENT, fields, this.analyzer);
            Query query = parser.parse(searchString);
            this.resetSearchResults(is, query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private void resetSearchResults(IndexSearcher searcher, Query query) {
        try {
            this.rowToModelIndex.clear();
            CountingCollector countingCollector = new CountingCollector();
            searcher.search(query, (Collector)countingCollector);
            ScoreDoc[] hits = searcher.search((Query)query, (int)countingCollector.numHits).scoreDocs;
            for (int t = 0; t < hits.length; ++t) {
                Document document = searcher.doc(hits[t].doc);
                Field field = document.getField(ROW_NUMBER);
                this.rowToModelIndex.add(Integer.valueOf(field.stringValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.reindex();
        if (this.isSearching()) {
            this.search(this.searchString);
        }
    }

    private boolean isSearching() {
        return this.searchString != null;
    }

    private void clearSearchingState() {
        this.searchString = null;
        this.rowToModelIndex.clear();
        for (int t = 0; t < this.listModel.getSize(); ++t) {
            this.rowToModelIndex.add(t);
        }
    }

    private int getModelRow(int row) {
        return this.rowToModelIndex.get(row);
    }

    public int getSize() {
        return this.listModel == null ? 0 : this.rowToModelIndex.size();
    }

    public Object getElementAt(int index) {
        return this.listModel.getElementAt(this.getModelRow(index));
    }

    class ListModelHandler
    implements ListDataListener {
        ListModelHandler() {
        }

        public void contentsChanged(ListDataEvent e) {
            this.somethingChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.somethingChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.somethingChanged();
        }

        private void somethingChanged() {
            if (!ListSearcher.this.isSearching()) {
                ListSearcher.this.clearSearchingState();
                ListSearcher.this.reindex();
                ListSearcher.this.fireContentsChanged(ListSearcher.this, 0, ListSearcher.this.getSize());
                return;
            }
            ListSearcher.this.reindex();
            ListSearcher.this.search(ListSearcher.this.searchString);
            ListSearcher.this.fireContentsChanged(ListSearcher.this, 0, ListSearcher.this.getSize());
        }
    }

    static final class CountingCollector
    extends Collector {
        public int numHits = 0;

        CountingCollector() {
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            ++this.numHits;
        }

        public void setNextReader(IndexReader reader, int docBase) {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

