/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.swing.models;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class ListSearcher
extends AbstractListModel {
    private ListModel listModel;
    private ArrayList rowToModelIndex = new ArrayList();
    private RAMDirectory directory;
    private Analyzer analyzer = new WhitespaceAnalyzer();
    private static final String ROW_NUMBER = "ROW_NUMBER";
    private static final String FIELD_NAME = "FIELD_NAME";
    private String searchString = null;
    private ListDataListener listModelListener;

    public ListSearcher(ListModel newModel) {
        this.setListModel(newModel);
        this.listModelListener = new ListModelHandler();
        newModel.addListDataListener(this.listModelListener);
        this.clearSearchingState();
    }

    private void setListModel(ListModel newModel) {
        if (newModel != null) {
            newModel.removeListDataListener(this.listModelListener);
        }
        this.listModel = newModel;
        if (this.listModel != null) {
            this.listModel.addListDataListener(this.listModelListener);
        }
        this.reindex();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private void reindex() {
        try {
            this.directory = new RAMDirectory();
            IndexWriter writer = new IndexWriter((Directory)this.directory, this.analyzer, true);
            for (int row = 0; row < this.listModel.getSize(); ++row) {
                Document document = new Document();
                document.add((Fieldable)new Field(ROW_NUMBER, "" + row, Field.Store.YES, Field.Index.TOKENIZED));
                document.add((Fieldable)new Field(FIELD_NAME, String.valueOf(this.listModel.getElementAt(row)).toLowerCase(), Field.Store.YES, Field.Index.TOKENIZED));
                writer.addDocument(document);
            }
            writer.optimize();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void search(String searchString) {
        if (searchString == null || searchString.equals("")) {
            this.clearSearchingState();
            this.fireContentsChanged(this, 0, this.getSize());
            return;
        }
        try {
            this.searchString = searchString;
            IndexSearcher is = new IndexSearcher((Directory)this.directory);
            String[] fields = new String[]{FIELD_NAME};
            MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, this.analyzer);
            Query query = parser.parse(searchString);
            Hits hits = is.search(query);
            this.resetSearchResults(hits);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private void resetSearchResults(Hits hits) {
        try {
            this.rowToModelIndex.clear();
            for (int t = 0; t < hits.length(); ++t) {
                Document document = hits.doc(t);
                Field field = document.getField(ROW_NUMBER);
                this.rowToModelIndex.add(new Integer(field.stringValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.reindex();
        if (this.isSearching()) {
            this.search(this.searchString);
        }
    }

    private boolean isSearching() {
        return this.searchString != null;
    }

    private void clearSearchingState() {
        this.searchString = null;
        this.rowToModelIndex.clear();
        for (int t = 0; t < this.listModel.getSize(); ++t) {
            this.rowToModelIndex.add(new Integer(t));
        }
    }

    private int getModelRow(int row) {
        return (Integer)this.rowToModelIndex.get(row);
    }

    public int getSize() {
        return this.listModel == null ? 0 : this.rowToModelIndex.size();
    }

    public Object getElementAt(int index) {
        return this.listModel.getElementAt(this.getModelRow(index));
    }

    class ListModelHandler
    implements ListDataListener {
        ListModelHandler() {
        }

        public void contentsChanged(ListDataEvent e) {
            this.somethingChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.somethingChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.somethingChanged();
        }

        private void somethingChanged() {
            if (!ListSearcher.this.isSearching()) {
                ListSearcher.this.clearSearchingState();
                ListSearcher.this.reindex();
                ListSearcher.this.fireContentsChanged(ListSearcher.this, 0, ListSearcher.this.getSize());
                return;
            }
            ListSearcher.this.reindex();
            ListSearcher.this.search(ListSearcher.this.searchString);
            ListSearcher.this.fireContentsChanged(ListSearcher.this, 0, ListSearcher.this.getSize());
        }
    }
}

