/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.swing.models;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class TableSearcher
extends AbstractTableModel {
    protected TableModel tableModel;
    private TableModelListener tableModelListener;
    private ArrayList rowToModelIndex = new ArrayList();
    private RAMDirectory directory;
    private Analyzer analyzer = new WhitespaceAnalyzer();
    private static final String ROW_NUMBER = "ROW_NUMBER";
    private String searchString = null;

    public TableSearcher(TableModel tableModel) {
        this.tableModelListener = new TableModelHandler();
        this.setTableModel(tableModel);
        tableModel.addTableModelListener(this.tableModelListener);
        this.clearSearchingState();
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.reindex();
        this.fireTableStructureChanged();
    }

    private void reindex() {
        try {
            this.directory = new RAMDirectory();
            IndexWriter writer = new IndexWriter((Directory)this.directory, this.analyzer, true);
            for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                Document document = new Document();
                document.add((Fieldable)new Field(ROW_NUMBER, "" + row, Field.Store.YES, Field.Index.TOKENIZED));
                for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
                    String columnName = this.tableModel.getColumnName(column);
                    String columnValue = String.valueOf(this.tableModel.getValueAt(row, column)).toLowerCase();
                    document.add((Fieldable)new Field(columnName, columnValue, Field.Store.YES, Field.Index.TOKENIZED));
                }
                writer.addDocument(document);
            }
            writer.optimize();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.reindex();
        if (this.isSearching()) {
            this.search(this.searchString);
        }
    }

    public void search(String searchString) {
        if (searchString == null || searchString.equals("")) {
            this.clearSearchingState();
            this.fireTableDataChanged();
            return;
        }
        try {
            this.searchString = searchString;
            IndexSearcher is = new IndexSearcher((Directory)this.directory);
            String[] fields = new String[this.tableModel.getColumnCount()];
            for (int t = 0; t < this.tableModel.getColumnCount(); ++t) {
                fields[t] = this.tableModel.getColumnName(t);
            }
            MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, this.analyzer);
            Query query = parser.parse(searchString);
            Hits hits = is.search(query);
            this.resetSearchResults(hits);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fireTableStructureChanged();
    }

    private void resetSearchResults(Hits hits) {
        try {
            this.rowToModelIndex.clear();
            for (int t = 0; t < hits.length(); ++t) {
                Document document = hits.doc(t);
                Field field = document.getField(ROW_NUMBER);
                this.rowToModelIndex.add(new Integer(field.stringValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getModelRow(int row) {
        return (Integer)this.rowToModelIndex.get(row);
    }

    private void clearSearchingState() {
        this.searchString = null;
        this.rowToModelIndex.clear();
        for (int t = 0; t < this.tableModel.getRowCount(); ++t) {
            this.rowToModelIndex.add(new Integer(t));
        }
    }

    public int getRowCount() {
        return this.tableModel == null ? 0 : this.rowToModelIndex.size();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.getModelRow(row), column);
    }

    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(this.getModelRow(row), column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, this.getModelRow(row), column);
    }

    private boolean isSearching() {
        return this.searchString != null;
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            if (!TableSearcher.this.isSearching()) {
                TableSearcher.this.clearSearchingState();
                TableSearcher.this.reindex();
                TableSearcher.this.fireTableChanged(e);
                return;
            }
            TableSearcher.this.reindex();
            TableSearcher.this.search(TableSearcher.this.searchString);
            TableSearcher.this.fireTableDataChanged();
        }
    }
}

