/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.surround.query.SimpleTerm;

public class SrndTruncQuery
extends SimpleTerm {
    private final String truncated;
    private final char unlimited;
    private final char mask;
    private String prefix;
    private Pattern pattern;

    public SrndTruncQuery(String truncated, char unlimited, char mask) {
        super(false);
        this.truncated = truncated;
        this.unlimited = unlimited;
        this.mask = mask;
        this.truncatedToPrefixAndPattern();
    }

    public String getTruncated() {
        return this.truncated;
    }

    public String toStringUnquoted() {
        return this.getTruncated();
    }

    protected boolean matchingChar(char c) {
        return c != this.unlimited && c != this.mask;
    }

    protected void appendRegExpForChar(char c, StringBuilder re) {
        if (c == this.unlimited) {
            re.append(".*");
        } else if (c == this.mask) {
            re.append(".");
        } else {
            re.append(c);
        }
    }

    protected void truncatedToPrefixAndPattern() {
        int i;
        for (i = 0; i < this.truncated.length() && this.matchingChar(this.truncated.charAt(i)); ++i) {
        }
        this.prefix = this.truncated.substring(0, i);
        StringBuilder re = new StringBuilder();
        while (i < this.truncated.length()) {
            this.appendRegExpForChar(this.truncated.charAt(i), re);
            ++i;
        }
        this.pattern = Pattern.compile(re.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        boolean expanded = false;
        int prefixLength = this.prefix.length();
        TermEnum enumerator = reader.terms(new Term(fieldName, this.prefix));
        Matcher matcher = this.pattern.matcher("");
        try {
            do {
                Term term;
                if ((term = enumerator.term()) == null) continue;
                String text = term.text();
                if (!text.startsWith(this.prefix)) break;
                if (!term.field().equals(fieldName)) {
                    break;
                }
                matcher.reset(text.substring(prefixLength));
                if (!matcher.matches()) continue;
                mtv.visitMatchingTerm(term);
                expanded = true;
            } while (enumerator.next());
        }
        finally {
            enumerator.close();
            matcher.reset();
        }
        if (!expanded) {
            System.out.println("No terms in " + fieldName + " field for: " + this.toString());
        }
    }
}

