/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.NoOutputs;
import org.apache.lucene.util.fst.Outputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSTLookup
extends Lookup {
    public static final String FILENAME = "fst.dat";
    private static final List<Lookup.LookupResult> EMPTY_RESULT = Collections.emptyList();
    private final int buckets;
    private final boolean exactMatchFirst;
    private FST<Object> automaton;
    private FST.Arc<Object>[] rootArcs;

    public FSTLookup() {
        this(10, true);
    }

    public FSTLookup(int buckets, boolean exactMatchFirst) {
        this.buckets = buckets;
        this.exactMatchFirst = exactMatchFirst;
    }

    @Override
    public void build(TermFreqIterator tfit) throws IOException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while (tfit.hasNext()) {
            String term = (String)tfit.next();
            char[] termChars = new char[term.length() + 1];
            for (int i = 0; i < term.length(); ++i) {
                termChars[i + 1] = term.charAt(i);
            }
            entries.add(new Entry(termChars, tfit.freq()));
        }
        if (entries.size() > 0) {
            this.redistributeWeightsProportionalMinMax(entries, this.buckets);
            this.encodeWeightPrefix(entries);
        }
        this.automaton = this.buildAutomaton(entries);
        this.cacheRootArcs();
    }

    private void cacheRootArcs() throws IOException {
        if (this.automaton != null) {
            ArrayList<FST.Arc> rootArcs = new ArrayList<FST.Arc>();
            FST.Arc arc = this.automaton.getFirstArc(new FST.Arc());
            this.automaton.readFirstTargetArc(arc, arc);
            while (true) {
                rootArcs.add(new FST.Arc().copyFrom(arc));
                if (arc.isLast()) break;
                this.automaton.readNextArc(arc);
            }
            Collections.reverse(rootArcs);
            this.rootArcs = rootArcs.toArray(new FST.Arc[rootArcs.size()]);
        }
    }

    @Override
    public boolean add(String key, Object value) {
        return false;
    }

    @Override
    public Float get(String key) {
        return this.getExactMatchStartingFromRootArc(0, key);
    }

    private Float getExactMatchStartingFromRootArc(int i, String key) {
        try {
            FST.Arc scratch = new FST.Arc();
            while (i < this.rootArcs.length) {
                FST.Arc<Object> rootArc = this.rootArcs[i];
                FST.Arc arc = scratch.copyFrom(rootArc);
                if (this.descendWithPrefix((FST.Arc<Object>)arc, key)) {
                    this.automaton.readFirstTargetArc(arc, arc);
                    if (arc.label == -1) {
                        return Float.valueOf((float)rootArc.label / (float)this.buckets);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public List<Lookup.LookupResult> lookup(String key, boolean onlyMorePopular, int num) {
        if (key.length() == 0 || this.automaton == null) {
            return EMPTY_RESULT;
        }
        try {
            if (!onlyMorePopular && this.rootArcs.length > 1) {
                return this.lookupSortedAlphabetically(key, num);
            }
            return this.lookupSortedByWeight(key, num, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Lookup.LookupResult> lookupSortedAlphabetically(String key, int num) throws IOException {
        List<Lookup.LookupResult> res = this.lookupSortedByWeight(key, num, false);
        Collections.sort(res, new Comparator<Lookup.LookupResult>(){

            @Override
            public int compare(Lookup.LookupResult o1, Lookup.LookupResult o2) {
                return o1.key.compareTo(o2.key);
            }
        });
        if (res.size() > num) {
            res = res.subList(0, num);
        }
        return res;
    }

    private ArrayList<Lookup.LookupResult> lookupSortedByWeight(String key, int num, boolean greedy) throws IOException {
        ArrayList<Lookup.LookupResult> res = new ArrayList<Lookup.LookupResult>(Math.min(10, num));
        StringBuilder output = new StringBuilder(key);
        int matchLength = key.length() - 1;
        for (int i = 0; i < this.rootArcs.length; ++i) {
            Float exactMatchWeight;
            FST.Arc<Object> rootArc = this.rootArcs[i];
            FST.Arc arc = new FST.Arc().copyFrom(rootArc);
            if (!this.descendWithPrefix((FST.Arc<Object>)arc, key)) continue;
            float weight = (float)rootArc.label / (float)this.buckets;
            output.setLength(matchLength);
            if (!this.collect(res, num, weight, output, (FST.Arc<Object>)arc) || !greedy) continue;
            if (!this.exactMatchFirst || (exactMatchWeight = this.getExactMatchStartingFromRootArc(i, key)) == null) break;
            res.add(0, new Lookup.LookupResult(key, exactMatchWeight.floatValue()));
            while (res.size() > num) {
                res.remove(res.size() - 1);
            }
            break;
        }
        return res;
    }

    private boolean descendWithPrefix(FST.Arc<Object> arc, String term) throws IOException {
        int max = term.length();
        for (int i = 0; i < max; ++i) {
            if (this.automaton.findTargetArc(term.charAt(i) & 0xFFFF, arc, arc) != null) continue;
            return false;
        }
        return true;
    }

    private boolean collect(List<Lookup.LookupResult> res, int num, float weight, StringBuilder output, FST.Arc<Object> arc) throws IOException {
        output.append((char)arc.label);
        this.automaton.readFirstTargetArc(arc, arc);
        while (true) {
            if (arc.label == -1) {
                res.add(new Lookup.LookupResult(output.toString(), weight));
                if (res.size() >= num) {
                    return true;
                }
            } else {
                int save = output.length();
                if (this.collect(res, num, weight, output, (FST.Arc<Object>)new FST.Arc().copyFrom(arc))) {
                    return true;
                }
                output.setLength(save);
            }
            if (arc.isLast()) break;
            this.automaton.readNextArc(arc);
        }
        return false;
    }

    private FST<Object> buildAutomaton(List<Entry> entries) throws IOException {
        if (entries.size() == 0) {
            return null;
        }
        Comparator<Entry> comp = new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                char[] ch1 = o1.term;
                char[] ch2 = o2.term;
                int len1 = ch1.length;
                int len2 = ch2.length;
                int max = Math.min(len1, len2);
                for (int i = 0; i < max; ++i) {
                    int v = ch1[i] - ch2[i];
                    if (v == 0) continue;
                    return v;
                }
                return len1 - len2;
            }
        };
        Collections.sort(entries, comp);
        int len = entries.size();
        int j = 0;
        for (int i = 1; i < len; ++i) {
            if (comp.compare(entries.get(j), entries.get(i)) == 0) continue;
            entries.set(++j, entries.get(i));
        }
        entries = entries.subList(0, j + 1);
        NoOutputs outputs = NoOutputs.getSingleton();
        Object empty = outputs.getNoOutput();
        Builder builder = new Builder(FST.INPUT_TYPE.BYTE4, 0, 0, true, (Outputs)outputs);
        IntsRef scratchIntsRef = new IntsRef(10);
        for (Entry e : entries) {
            int termLength = scratchIntsRef.length = e.term.length;
            scratchIntsRef.grow(termLength);
            int[] ints = scratchIntsRef.ints;
            char[] chars = e.term;
            int i = termLength;
            while (--i >= 0) {
                ints[i] = chars[i];
            }
            builder.add(scratchIntsRef, empty);
        }
        return builder.finish();
    }

    private void encodeWeightPrefix(List<Entry> entries) {
        for (Entry e : entries) {
            int weight = (int)e.weight;
            assert (weight >= 0 && weight <= this.buckets) : "Weight out of range: " + weight + " [" + this.buckets + "]";
            e.term[0] = (char)weight;
        }
    }

    private void redistributeWeightsProportionalMinMax(List<Entry> entries, int buckets) {
        float min;
        float max = min = entries.get((int)0).weight;
        for (Entry e : entries) {
            min = Math.min(e.weight, min);
            max = Math.max(e.weight, max);
        }
        float range = max - min;
        for (Entry e : entries) {
            e.weight = (int)((float)buckets * ((e.weight - min) / range));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load(File storeDir) throws IOException {
        File data = new File(storeDir, FILENAME);
        if (!data.exists() || !data.canRead()) {
            return false;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(data));
        try {
            this.automaton = new FST((DataInput)new InputStreamDataInput((InputStream)is), (Outputs)NoOutputs.getSingleton());
            this.cacheRootArcs();
        }
        catch (Throwable throwable) {
            IOUtils.closeSafely((boolean)false, (Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOUtils.closeSafely((boolean)false, (Closeable[])new Closeable[]{is});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean store(File storeDir) throws IOException {
        if (!(storeDir.exists() && storeDir.isDirectory() && storeDir.canWrite())) {
            return false;
        }
        if (this.automaton == null) {
            return false;
        }
        File data = new File(storeDir, FILENAME);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(data));
        try {
            this.automaton.save((DataOutput)new OutputStreamDataOutput((OutputStream)os));
        }
        catch (Throwable throwable) {
            IOUtils.closeSafely((boolean)false, (Closeable[])new Closeable[]{os});
            throw throwable;
        }
        IOUtils.closeSafely((boolean)false, (Closeable[])new Closeable[]{os});
        return true;
    }

    private static class Entry {
        char[] term;
        float weight;

        public Entry(char[] term, float freq) {
            this.term = term;
            this.weight = freq;
        }
    }
}

