/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBaseDistanceShape;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;
import org.apache.lucene.geo3d.Vector;

public class GeoPath
extends GeoBaseDistanceShape {
    protected final double cutoffAngle;
    protected final double sinAngle;
    protected final double cosAngle;
    protected final List<GeoPoint> points = new ArrayList<GeoPoint>();
    protected List<SegmentEndpoint> endPoints;
    protected List<PathSegment> segments;
    protected GeoPoint[] edgePoints;
    protected boolean isDone = false;

    public GeoPath(PlanetModel planetModel, double maxCutoffAngle, GeoPoint[] pathPoints) {
        this(planetModel, maxCutoffAngle);
        Collections.addAll(this.points, pathPoints);
        this.done();
    }

    public GeoPath(PlanetModel planetModel, double maxCutoffAngle) {
        super(planetModel);
        if (maxCutoffAngle <= 0.0 || maxCutoffAngle > 1.5707963267948966) {
            throw new IllegalArgumentException("Cutoff angle out of bounds");
        }
        this.cutoffAngle = maxCutoffAngle;
        this.cosAngle = Math.cos(maxCutoffAngle);
        this.sinAngle = Math.sin(maxCutoffAngle);
    }

    public void addPoint(double lat, double lon) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call addPoint() if done() already called");
        }
        this.points.add(new GeoPoint(this.planetModel, lat, lon));
    }

    public void done() {
        if (this.isDone) {
            throw new IllegalStateException("Can't call done() twice");
        }
        if (this.points.size() == 0) {
            throw new IllegalArgumentException("Path must have at least one point");
        }
        this.isDone = true;
        this.endPoints = new ArrayList<SegmentEndpoint>(this.points.size());
        this.segments = new ArrayList<PathSegment>(this.points.size());
        double cutoffOffset = this.sinAngle * this.planetModel.getMinimumMagnitude();
        GeoPoint lastPoint = null;
        for (GeoPoint end : this.points) {
            if (lastPoint != null) {
                Plane normalizedConnectingPlane = new Plane((Vector)lastPoint, end);
                if (normalizedConnectingPlane == null) continue;
                this.segments.add(new PathSegment(this.planetModel, lastPoint, end, normalizedConnectingPlane, cutoffOffset));
            }
            lastPoint = end;
        }
        if (this.segments.size() == 0) {
            double lat = this.points.get(0).getLatitude();
            double lon = this.points.get(0).getLongitude();
            double upperLat = lat + this.cutoffAngle;
            double upperLon = lon;
            if (upperLat > 1.5707963267948966) {
                if ((upperLon += Math.PI) > Math.PI) {
                    upperLon -= Math.PI * 2;
                }
                upperLat = Math.PI - upperLat;
            }
            double lowerLat = lat - this.cutoffAngle;
            double lowerLon = lon;
            if (lowerLat < -1.5707963267948966) {
                if ((lowerLon += Math.PI) > Math.PI) {
                    lowerLon -= Math.PI * 2;
                }
                lowerLat = -Math.PI - lowerLat;
            }
            GeoPoint upperPoint = new GeoPoint(this.planetModel, upperLat, upperLon);
            GeoPoint lowerPoint = new GeoPoint(this.planetModel, lowerLat, lowerLon);
            SegmentEndpoint onlyEndpoint = new SegmentEndpoint(this.points.get(0), upperPoint, lowerPoint);
            this.endPoints.add(onlyEndpoint);
            this.edgePoints = new GeoPoint[]{upperPoint};
            return;
        }
        for (int i = 0; i < this.segments.size(); ++i) {
            PathSegment currentSegment = this.segments.get(i);
            if (i == 0) {
                SegmentEndpoint startEndpoint = new SegmentEndpoint(currentSegment.start, currentSegment.startCutoffPlane, currentSegment.ULHC, currentSegment.LLHC);
                this.endPoints.add(startEndpoint);
                this.edgePoints = new GeoPoint[]{currentSegment.ULHC};
                continue;
            }
            PathSegment prevSegment = this.segments.get(i - 1);
            SidedPlane candidate1 = SidedPlane.constructNormalizedThreePointSidedPlane(currentSegment.start, prevSegment.URHC, currentSegment.ULHC, currentSegment.LLHC);
            SidedPlane candidate2 = SidedPlane.constructNormalizedThreePointSidedPlane(currentSegment.start, currentSegment.ULHC, currentSegment.LLHC, prevSegment.LRHC);
            SidedPlane candidate3 = SidedPlane.constructNormalizedThreePointSidedPlane(currentSegment.start, currentSegment.LLHC, prevSegment.LRHC, prevSegment.URHC);
            SidedPlane candidate4 = SidedPlane.constructNormalizedThreePointSidedPlane(currentSegment.start, prevSegment.LRHC, prevSegment.URHC, currentSegment.ULHC);
            if (candidate1 == null && candidate2 == null && candidate3 == null && candidate4 == null) {
                SegmentEndpoint midEndpoint = new SegmentEndpoint(currentSegment.start, prevSegment.endCutoffPlane, currentSegment.startCutoffPlane, currentSegment.ULHC, currentSegment.LLHC);
                this.endPoints.add(midEndpoint);
                continue;
            }
            this.endPoints.add(new SegmentEndpoint(currentSegment.start, prevSegment.endCutoffPlane, currentSegment.startCutoffPlane, prevSegment.URHC, prevSegment.LRHC, currentSegment.ULHC, currentSegment.LLHC, candidate1, candidate2, candidate3, candidate4));
        }
        PathSegment lastSegment = this.segments.get(this.segments.size() - 1);
        this.endPoints.add(new SegmentEndpoint(lastSegment.end, lastSegment.endCutoffPlane, lastSegment.URHC, lastSegment.LRHC));
    }

    @Override
    protected double distance(DistanceStyle distanceStyle, double x, double y, double z) {
        double currentDistance = 0.0;
        for (PathSegment segment : this.segments) {
            double distance = segment.pathDistance(this.planetModel, distanceStyle, x, y, z);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            currentDistance += segment.fullPathDistance(distanceStyle);
        }
        int segmentIndex = 0;
        currentDistance = 0.0;
        for (SegmentEndpoint endpoint : this.endPoints) {
            double distance = endpoint.pathDistance(distanceStyle, x, y, z);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            if (segmentIndex >= this.segments.size()) continue;
            currentDistance += this.segments.get(segmentIndex++).fullPathDistance(distanceStyle);
        }
        return Double.MAX_VALUE;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double newDistance;
        double minDistance = Double.MAX_VALUE;
        for (SegmentEndpoint endpoint : this.endPoints) {
            newDistance = endpoint.outsideDistance(distanceStyle, x, y, z);
            if (!(newDistance < minDistance)) continue;
            minDistance = newDistance;
        }
        for (PathSegment segment : this.segments) {
            newDistance = segment.outsideDistance(this.planetModel, distanceStyle, x, y, z);
            if (!(newDistance < minDistance)) continue;
            minDistance = newDistance;
        }
        return minDistance;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (SegmentEndpoint pathPoint : this.endPoints) {
            if (!pathPoint.isWithin(x, y, z)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
        for (SegmentEndpoint pathPoint : this.endPoints) {
            if (!pathPoint.intersects(this.planetModel, plane, notablePoints, bounds)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.intersects(this.planetModel, plane, notablePoints, bounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        bounds = super.getBounds(bounds);
        for (PathSegment pathSegment : this.segments) {
            pathSegment.getBounds(this.planetModel, bounds);
        }
        for (SegmentEndpoint pathPoint : this.endPoints) {
            pathPoint.getBounds(this.planetModel, bounds);
        }
        return bounds;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoPath)) {
            return false;
        }
        GeoPath p = (GeoPath)o;
        if (!super.equals(p)) {
            return false;
        }
        if (this.cutoffAngle != p.cutoffAngle) {
            return false;
        }
        return this.points.equals(p.points);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.cutoffAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.points.hashCode();
        return result;
    }

    public String toString() {
        return "GeoPath: {planetmodel=" + this.planetModel + ", width=" + this.cutoffAngle + "(" + this.cutoffAngle * 180.0 / Math.PI + "), points={" + this.points + "}}";
    }

    public static class PathSegment {
        public final GeoPoint start;
        public final GeoPoint end;
        public final Map<DistanceStyle, Double> fullDistanceCache = new HashMap<DistanceStyle, Double>();
        public final Plane normalizedConnectingPlane;
        public final SidedPlane upperConnectingPlane;
        public final SidedPlane lowerConnectingPlane;
        public final SidedPlane startCutoffPlane;
        public final SidedPlane endCutoffPlane;
        public final GeoPoint URHC;
        public final GeoPoint LRHC;
        public final GeoPoint ULHC;
        public final GeoPoint LLHC;
        public final GeoPoint[] upperConnectingPlanePoints;
        public final GeoPoint[] lowerConnectingPlanePoints;
        public final GeoPoint[] startCutoffPlanePoints;
        public final GeoPoint[] endCutoffPlanePoints;

        public PathSegment(PlanetModel planetModel, GeoPoint start, GeoPoint end, Plane normalizedConnectingPlane, double planeBoundingOffset) {
            this.start = start;
            this.end = end;
            this.normalizedConnectingPlane = normalizedConnectingPlane;
            this.upperConnectingPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, -planeBoundingOffset);
            this.lowerConnectingPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, planeBoundingOffset);
            this.startCutoffPlane = new SidedPlane((Vector)end, (Vector)normalizedConnectingPlane, start);
            this.endCutoffPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, end);
            Membership[] upperSide = new Membership[]{this.upperConnectingPlane};
            Membership[] lowerSide = new Membership[]{this.lowerConnectingPlane};
            Membership[] startSide = new Membership[]{this.startCutoffPlane};
            Membership[] endSide = new Membership[]{this.endCutoffPlane};
            GeoPoint[] points = this.upperConnectingPlane.findIntersections(planetModel, (Plane)this.startCutoffPlane, lowerSide, endSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            this.ULHC = points[0];
            points = this.upperConnectingPlane.findIntersections(planetModel, (Plane)this.endCutoffPlane, lowerSide, startSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            this.URHC = points[0];
            points = this.lowerConnectingPlane.findIntersections(planetModel, (Plane)this.startCutoffPlane, upperSide, endSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            this.LLHC = points[0];
            points = this.lowerConnectingPlane.findIntersections(planetModel, (Plane)this.endCutoffPlane, upperSide, startSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            this.LRHC = points[0];
            this.upperConnectingPlanePoints = new GeoPoint[]{this.ULHC, this.URHC};
            this.lowerConnectingPlanePoints = new GeoPoint[]{this.LLHC, this.LRHC};
            this.startCutoffPlanePoints = new GeoPoint[]{this.ULHC, this.LLHC};
            this.endCutoffPlanePoints = new GeoPoint[]{this.URHC, this.LRHC};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double fullPathDistance(DistanceStyle distanceStyle) {
            Map<DistanceStyle, Double> map = this.fullDistanceCache;
            synchronized (map) {
                Double dist = this.fullDistanceCache.get(distanceStyle);
                if (dist == null) {
                    dist = new Double(distanceStyle.computeDistance(this.start, this.end.x, this.end.y, this.end.z));
                    this.fullDistanceCache.put(distanceStyle, dist);
                }
                return dist;
            }
        }

        public boolean isWithin(Vector point) {
            return this.startCutoffPlane.isWithin(point) && this.endCutoffPlane.isWithin(point) && this.upperConnectingPlane.isWithin(point) && this.lowerConnectingPlane.isWithin(point);
        }

        public boolean isWithin(double x, double y, double z) {
            return this.startCutoffPlane.isWithin(x, y, z) && this.endCutoffPlane.isWithin(x, y, z) && this.upperConnectingPlane.isWithin(x, y, z) && this.lowerConnectingPlane.isWithin(x, y, z);
        }

        public double pathDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithin(x, y, z)) {
                return Double.MAX_VALUE;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.computeDistance(this.start, x, y, z);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.computeDistance(thePoint, x, y, z) + distanceStyle.computeDistance(this.start, thePoint.x, thePoint.y, thePoint.z);
        }

        public double outsideDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            double upperDistance = distanceStyle.computeDistance(planetModel, (Plane)this.upperConnectingPlane, x, y, z, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            double lowerDistance = distanceStyle.computeDistance(planetModel, (Plane)this.lowerConnectingPlane, x, y, z, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            double startDistance = distanceStyle.computeDistance(planetModel, (Plane)this.startCutoffPlane, x, y, z, this.endCutoffPlane, this.lowerConnectingPlane, this.upperConnectingPlane);
            double endDistance = distanceStyle.computeDistance(planetModel, (Plane)this.endCutoffPlane, x, y, z, this.startCutoffPlane, this.lowerConnectingPlane, this.upperConnectingPlane);
            double ULHCDistance = distanceStyle.computeDistance(this.ULHC, x, y, z);
            double URHCDistance = distanceStyle.computeDistance(this.URHC, x, y, z);
            double LLHCDistance = distanceStyle.computeDistance(this.LLHC, x, y, z);
            double LRHCDistance = distanceStyle.computeDistance(this.LRHC, x, y, z);
            return Math.min(Math.min(Math.min(upperDistance, lowerDistance), Math.min(startDistance, endDistance)), Math.min(Math.min(ULHCDistance, URHCDistance), Math.min(LLHCDistance, LRHCDistance)));
        }

        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.upperConnectingPlane.intersects(planetModel, p, notablePoints, this.upperConnectingPlanePoints, bounds, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane) || this.lowerConnectingPlane.intersects(planetModel, p, notablePoints, this.lowerConnectingPlanePoints, bounds, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
        }

        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            bounds.addPoint(this.start).addPoint(this.end);
            this.upperConnectingPlane.recordBounds(planetModel, this.startCutoffPlane, bounds, this.lowerConnectingPlane, this.endCutoffPlane);
            this.startCutoffPlane.recordBounds(planetModel, this.lowerConnectingPlane, bounds, this.endCutoffPlane, this.upperConnectingPlane);
            this.lowerConnectingPlane.recordBounds(planetModel, this.endCutoffPlane, bounds, this.upperConnectingPlane, this.startCutoffPlane);
            this.endCutoffPlane.recordBounds(planetModel, this.upperConnectingPlane, bounds, this.startCutoffPlane, this.lowerConnectingPlane);
            this.upperConnectingPlane.recordBounds(planetModel, bounds, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            this.lowerConnectingPlane.recordBounds(planetModel, bounds, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            this.startCutoffPlane.recordBounds(planetModel, bounds, this.endCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane);
            this.endCutoffPlane.recordBounds(planetModel, bounds, this.startCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane);
        }
    }

    public static class SegmentEndpoint {
        public final GeoPoint point;
        public final SidedPlane circlePlane;
        public final Membership[] cutoffPlanes;
        public final GeoPoint[] notablePoints;
        public static final GeoPoint[] circlePoints = new GeoPoint[0];

        public SegmentEndpoint(GeoPoint point) {
            this.point = point;
            this.circlePlane = null;
            this.cutoffPlanes = null;
            this.notablePoints = null;
        }

        public SegmentEndpoint(GeoPoint point, GeoPoint upperPoint, GeoPoint lowerPoint) {
            this.point = point;
            Plane normalPlane = Plane.constructNormalizedVerticalPlane(upperPoint, lowerPoint, point);
            this.circlePlane = SidedPlane.constructNormalizedPerpendicularSidedPlane(point, normalPlane, upperPoint, lowerPoint);
            this.cutoffPlanes = new Membership[0];
            this.notablePoints = new GeoPoint[0];
        }

        public SegmentEndpoint(GeoPoint point, SidedPlane cutoffPlane, GeoPoint topEdgePoint, GeoPoint bottomEdgePoint) {
            this.point = point;
            this.cutoffPlanes = new Membership[]{new SidedPlane(cutoffPlane)};
            this.notablePoints = new GeoPoint[]{topEdgePoint, bottomEdgePoint};
            this.circlePlane = SidedPlane.constructNormalizedPerpendicularSidedPlane(point, cutoffPlane, topEdgePoint, bottomEdgePoint);
        }

        public SegmentEndpoint(GeoPoint point, SidedPlane cutoffPlane1, SidedPlane cutoffPlane2, GeoPoint topEdgePoint, GeoPoint bottomEdgePoint) {
            this.point = point;
            this.cutoffPlanes = new Membership[]{new SidedPlane(cutoffPlane1), new SidedPlane(cutoffPlane2)};
            this.notablePoints = new GeoPoint[]{topEdgePoint, bottomEdgePoint};
            this.circlePlane = SidedPlane.constructNormalizedPerpendicularSidedPlane(point, cutoffPlane1, topEdgePoint, bottomEdgePoint);
        }

        public SegmentEndpoint(GeoPoint point, SidedPlane prevCutoffPlane, SidedPlane nextCutoffPlane, GeoPoint notCand2Point, GeoPoint notCand1Point, GeoPoint notCand3Point, GeoPoint notCand4Point, SidedPlane candidate1, SidedPlane candidate2, SidedPlane candidate3, SidedPlane candidate4) {
            boolean cand4IsOtherWithin;
            this.point = point;
            boolean cand1IsOtherWithin = candidate1 != null ? candidate1.isWithin(notCand1Point) : false;
            boolean cand2IsOtherWithin = candidate2 != null ? candidate2.isWithin(notCand2Point) : false;
            boolean cand3IsOtherWithin = candidate3 != null ? candidate3.isWithin(notCand3Point) : false;
            boolean bl = cand4IsOtherWithin = candidate4 != null ? candidate4.isWithin(notCand4Point) : false;
            if (cand1IsOtherWithin && cand2IsOtherWithin && cand3IsOtherWithin && cand4IsOtherWithin) {
                this.circlePlane = candidate1;
                this.notablePoints = new GeoPoint[]{notCand2Point, notCand3Point, notCand1Point, notCand4Point};
                this.cutoffPlanes = new Membership[]{new SidedPlane(prevCutoffPlane), new SidedPlane(nextCutoffPlane)};
            } else if (cand1IsOtherWithin) {
                this.circlePlane = candidate1;
                this.notablePoints = new GeoPoint[]{notCand2Point, notCand3Point, notCand4Point};
                this.cutoffPlanes = new Membership[]{new SidedPlane(nextCutoffPlane)};
            } else if (cand2IsOtherWithin) {
                this.circlePlane = candidate2;
                this.notablePoints = new GeoPoint[]{notCand3Point, notCand4Point, notCand1Point};
                this.cutoffPlanes = new Membership[]{new SidedPlane(nextCutoffPlane)};
            } else if (cand3IsOtherWithin) {
                this.circlePlane = candidate3;
                this.notablePoints = new GeoPoint[]{notCand4Point, notCand1Point, notCand2Point};
                this.cutoffPlanes = new Membership[]{new SidedPlane(prevCutoffPlane)};
            } else if (cand4IsOtherWithin) {
                this.circlePlane = candidate4;
                this.notablePoints = new GeoPoint[]{notCand1Point, notCand2Point, notCand3Point};
                this.cutoffPlanes = new Membership[]{new SidedPlane(prevCutoffPlane)};
            } else {
                throw new RuntimeException("Couldn't come up with a plane through three points that included the fourth");
            }
        }

        public boolean isWithin(Vector point) {
            if (this.circlePlane == null) {
                return false;
            }
            return this.circlePlane.isWithin(point);
        }

        public boolean isWithin(double x, double y, double z) {
            if (this.circlePlane == null) {
                return false;
            }
            return this.circlePlane.isWithin(x, y, z);
        }

        public double pathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.MAX_VALUE;
            }
            return distanceStyle.computeDistance(this.point, x, y, z);
        }

        public double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return distanceStyle.computeDistance(this.point, x, y, z);
        }

        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            if (this.circlePlane == null) {
                return false;
            }
            return this.circlePlane.intersects(planetModel, p, notablePoints, this.notablePoints, bounds, this.cutoffPlanes);
        }

        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            bounds.addPoint(this.point);
            if (this.circlePlane == null) {
                return;
            }
            this.circlePlane.recordBounds(planetModel, bounds, new Membership[0]);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SegmentEndpoint)) {
                return false;
            }
            SegmentEndpoint other = (SegmentEndpoint)o;
            return this.point.equals(other.point);
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public String toString() {
            return this.point.toString();
        }
    }
}

