/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQueryImpl;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.spatial.util.GeoRelationUtils;
import org.apache.lucene.util.SloppyMath;

final class GeoPointDistanceQueryImpl
extends GeoPointInBBoxQueryImpl {
    private final GeoPointDistanceQuery distanceQuery;
    private final double centerLon;

    GeoPointDistanceQueryImpl(String field, GeoPointField.TermEncoding termEncoding, GeoPointDistanceQuery q, double centerLonUnwrapped, GeoRect bbox) {
        super(field, termEncoding, bbox.minLat, bbox.maxLat, bbox.minLon, bbox.maxLon);
        this.distanceQuery = q;
        this.centerLon = centerLonUnwrapped;
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    protected GeoPointMultiTermQuery.CellComparator newCellComparator() {
        return new GeoPointRadiusCellComparator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoPointDistanceQueryImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointDistanceQueryImpl that = (GeoPointDistanceQueryImpl)((Object)o);
        return this.distanceQuery.equals((Object)that.distanceQuery);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.distanceQuery.hashCode();
        return result;
    }

    public double getRadiusMeters() {
        return this.distanceQuery.getRadiusMeters();
    }

    private final class GeoPointRadiusCellComparator
    extends GeoPointMultiTermQuery.CellComparator {
        GeoPointRadiusCellComparator(GeoPointDistanceQueryImpl query) {
            super(query);
        }

        @Override
        protected boolean cellCrosses(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectCrossesCircle(minLat, maxLat, minLon, maxLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.centerLat, GeoPointDistanceQueryImpl.this.centerLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.radiusMeters, true);
        }

        @Override
        protected boolean cellWithin(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectWithinCircle(minLat, maxLat, minLon, maxLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.centerLat, GeoPointDistanceQueryImpl.this.centerLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.radiusMeters, true);
        }

        @Override
        protected boolean cellIntersectsShape(double minLat, double maxLat, double minLon, double maxLon) {
            return this.cellCrosses(minLat, maxLat, minLon, maxLon);
        }

        @Override
        protected boolean postFilter(double lat, double lon) {
            return SloppyMath.haversinMeters((double)((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.centerLat, (double)GeoPointDistanceQueryImpl.this.centerLon, (double)lat, (double)lon) <= ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.radiusMeters;
        }
    }
}

