/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoSouthLatitudeZone
extends GeoBBoxBase {
    public final double topLat;
    public final double cosTopLat;
    public final SidedPlane topPlane;
    public final GeoPoint interiorPoint;
    public static final GeoPoint[] planePoints = new GeoPoint[0];
    public final GeoPoint topBoundaryPoint;
    public final GeoPoint[] edgePoints;

    public GeoSouthLatitudeZone(double topLat) {
        this.topLat = topLat;
        double sinTopLat = Math.sin(topLat);
        this.cosTopLat = Math.cos(topLat);
        Vector topPoint = new Vector(0.0, 0.0, sinTopLat);
        double middleLat = (topLat - 1.5707963267948966) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.interiorPoint = new GeoPoint(Math.sqrt(1.0 - sinMiddleLat * sinMiddleLat), 0.0, sinMiddleLat);
        this.topBoundaryPoint = new GeoPoint(Math.sqrt(1.0 - sinTopLat * sinTopLat), 0.0, sinTopLat);
        this.topPlane = new SidedPlane((Vector)this.interiorPoint, sinTopLat);
        this.edgePoints = new GeoPoint[]{this.topBoundaryPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = -1.5707963267948966;
        return GeoBBoxFactory.makeGeoBBox(newTopLat, -1.5707963267948966, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.topPlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.topPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        if (this.topLat > 0.0) {
            return Math.PI;
        }
        double maxCosLat = this.cosTopLat;
        return maxCosLat * Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.topPlane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noLongitudeBound().addLatitudeZone(this.topLat).noBottomLatitudeBound();
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideBBox(path);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path.isWithin(this.topBoundaryPoint);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path.intersects(this.topPlane, planePoints, new Membership[0])) {
            return 2;
        }
        if (insideShape) {
            return 0;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoSouthLatitudeZone)) {
            return false;
        }
        GeoSouthLatitudeZone other = (GeoSouthLatitudeZone)o;
        return other.topPlane.equals(this.topPlane);
    }

    public int hashCode() {
        int result = this.topPlane.hashCode();
        return result;
    }

    public String toString() {
        return "GeoSouthLatitudeZone: {toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + ")}";
    }
}

