/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBaseExtendedShape;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoDistanceShape;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Tools;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoPath
extends GeoBaseExtendedShape
implements GeoDistanceShape {
    public final double cutoffAngle;
    public final double cutoffOffset;
    public final double originDistance;
    public final double chordDistance;
    public final List<SegmentEndpoint> points = new ArrayList<SegmentEndpoint>();
    public final List<PathSegment> segments = new ArrayList<PathSegment>();
    public GeoPoint[] edgePoints = null;

    public GeoPath(double cutoffAngle) {
        double sinAngle;
        if (cutoffAngle <= 0.0 || cutoffAngle > 1.5707963267948966) {
            throw new IllegalArgumentException("Cutoff angle out of bounds");
        }
        this.cutoffAngle = cutoffAngle;
        double cosAngle = Math.cos(cutoffAngle);
        this.cutoffOffset = sinAngle = Math.sin(cutoffAngle);
        this.originDistance = cosAngle;
        double xDiff = 1.0 - cosAngle;
        this.chordDistance = Math.sqrt(xDiff * xDiff + sinAngle * sinAngle);
    }

    public void addPoint(double lat, double lon) {
        if (lat < -1.5707963267948966 || lat > 1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of range");
        }
        if (lon < -Math.PI || lon > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        GeoPoint end = new GeoPoint(lat, lon);
        if (this.points.size() > 0) {
            GeoPoint start = this.points.get((int)(this.points.size() - 1)).point;
            PathSegment ps = new PathSegment(start, end, this.cutoffOffset, this.cutoffAngle, this.chordDistance);
            if (ps.isDegenerate()) {
                return;
            }
            this.segments.add(ps);
        } else {
            double newLat = lat + this.cutoffAngle;
            double newLon = lon;
            if (newLat > 1.5707963267948966) {
                newLat = Math.PI - newLat;
                newLon += Math.PI;
            }
            while (newLon > Math.PI) {
                newLon -= Math.PI * 2;
            }
            GeoPoint edgePoint = new GeoPoint(newLat, newLon);
            this.edgePoints = new GeoPoint[]{edgePoint};
        }
        SegmentEndpoint se = new SegmentEndpoint(end, this.originDistance, this.cutoffOffset, this.cutoffAngle, this.chordDistance);
        this.points.add(se);
    }

    public void done() {
        if (this.points.size() == 0) {
            throw new IllegalArgumentException("Path must have at least one point");
        }
        if (this.segments.size() > 0) {
            this.edgePoints = new GeoPoint[]{this.points.get((int)0).circlePlane.getSampleIntersectionPoint(this.segments.get((int)0).invertedStartCutoffPlane)};
        }
        for (int i = 0; i < this.points.size(); ++i) {
            SegmentEndpoint pathPoint = this.points.get(i);
            SidedPlane previousEndBound = null;
            GeoPoint[] previousEndNotablePoints = null;
            SidedPlane nextStartBound = null;
            GeoPoint[] nextStartNotablePoints = null;
            if (i > 0) {
                PathSegment previousSegment = this.segments.get(i - 1);
                previousEndBound = previousSegment.invertedEndCutoffPlane;
                previousEndNotablePoints = previousSegment.endCutoffPlanePoints;
            }
            if (i < this.segments.size()) {
                PathSegment nextSegment = this.segments.get(i);
                nextStartBound = nextSegment.invertedStartCutoffPlane;
                nextStartNotablePoints = nextSegment.startCutoffPlanePoints;
            }
            pathPoint.setCutoffPlanes(previousEndNotablePoints, previousEndBound, nextStartNotablePoints, nextStartBound);
        }
    }

    @Override
    public double computeNormalDistance(GeoPoint point) {
        double currentDistance = 0.0;
        for (PathSegment segment : this.segments) {
            double distance = segment.pathNormalDistance(point);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            currentDistance += segment.fullNormalDistance;
        }
        int segmentIndex = 0;
        currentDistance = 0.0;
        for (SegmentEndpoint endpoint : this.points) {
            double distance = endpoint.pathNormalDistance(point);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            if (segmentIndex >= this.segments.size()) continue;
            currentDistance += this.segments.get((int)segmentIndex++).fullNormalDistance;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public double computeNormalDistance(double x, double y, double z) {
        return this.computeNormalDistance(new GeoPoint(x, y, z));
    }

    @Override
    public double computeSquaredNormalDistance(GeoPoint point) {
        double pd = this.computeNormalDistance(point);
        if (pd == Double.MAX_VALUE) {
            return pd;
        }
        return pd * pd;
    }

    @Override
    public double computeSquaredNormalDistance(double x, double y, double z) {
        return this.computeSquaredNormalDistance(new GeoPoint(x, y, z));
    }

    @Override
    public double computeLinearDistance(GeoPoint point) {
        double currentDistance = 0.0;
        for (PathSegment segment : this.segments) {
            double distance = segment.pathLinearDistance(point);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            currentDistance += segment.fullLinearDistance;
        }
        int segmentIndex = 0;
        currentDistance = 0.0;
        for (SegmentEndpoint endpoint : this.points) {
            double distance = endpoint.pathLinearDistance(point);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            if (segmentIndex >= this.segments.size()) continue;
            currentDistance += this.segments.get((int)segmentIndex++).fullLinearDistance;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public double computeLinearDistance(double x, double y, double z) {
        return this.computeLinearDistance(new GeoPoint(x, y, z));
    }

    @Override
    public double computeSquaredLinearDistance(GeoPoint point) {
        double pd = this.computeLinearDistance(point);
        if (pd == Double.MAX_VALUE) {
            return pd;
        }
        return pd * pd;
    }

    @Override
    public double computeSquaredLinearDistance(double x, double y, double z) {
        return this.computeSquaredLinearDistance(new GeoPoint(x, y, z));
    }

    @Override
    public double computeArcDistance(GeoPoint point) {
        double currentDistance = 0.0;
        for (PathSegment segment : this.segments) {
            double distance = segment.pathDistance(point);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            currentDistance += segment.fullDistance;
        }
        int segmentIndex = 0;
        currentDistance = 0.0;
        for (SegmentEndpoint endpoint : this.points) {
            double distance = endpoint.pathDistance(point);
            if (distance != Double.MAX_VALUE) {
                return currentDistance + distance;
            }
            if (segmentIndex >= this.segments.size()) continue;
            currentDistance += this.segments.get((int)segmentIndex++).fullDistance;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public boolean isWithin(Vector point) {
        for (SegmentEndpoint pathPoint : this.points) {
            if (!pathPoint.isWithin(point)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.isWithin(point)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (SegmentEndpoint pathPoint : this.points) {
            if (!pathPoint.isWithin(x, y, z)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
        for (SegmentEndpoint pathPoint : this.points) {
            if (!pathPoint.intersects(plane, notablePoints, bounds)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.intersects(plane, notablePoints, bounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        bounds = super.getBounds(bounds);
        for (PathSegment pathSegment : this.segments) {
            pathSegment.getBounds(bounds);
        }
        for (SegmentEndpoint pathPoint : this.points) {
            pathPoint.getBounds(bounds);
        }
        return bounds;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoPath)) {
            return false;
        }
        GeoPath p = (GeoPath)o;
        if (this.points.size() != p.points.size()) {
            return false;
        }
        if (this.cutoffAngle != p.cutoffAngle) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            SegmentEndpoint point2;
            SegmentEndpoint point = this.points.get(i);
            if (point.equals(point2 = p.points.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.cutoffAngle);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.points.hashCode();
        return result;
    }

    public String toString() {
        return "GeoPath: {width=" + this.cutoffAngle + "(" + this.cutoffAngle * 180.0 / Math.PI + "), points={" + this.points + "}}";
    }

    public static class PathSegment {
        public final GeoPoint start;
        public final GeoPoint end;
        public final double fullDistance;
        public final double fullNormalDistance;
        public final double fullLinearDistance;
        public final Plane normalizedConnectingPlane;
        public final SidedPlane upperConnectingPlane;
        public final SidedPlane lowerConnectingPlane;
        public final SidedPlane startCutoffPlane;
        public final SidedPlane endCutoffPlane;
        public final GeoPoint[] upperConnectingPlanePoints;
        public final GeoPoint[] lowerConnectingPlanePoints;
        public final GeoPoint[] startCutoffPlanePoints;
        public final GeoPoint[] endCutoffPlanePoints;
        public final double planeBoundingOffset;
        public final double arcWidth;
        public final double chordDistance;
        public final SidedPlane invertedStartCutoffPlane;
        public final SidedPlane invertedEndCutoffPlane;

        public PathSegment(GeoPoint start, GeoPoint end, double planeBoundingOffset, double arcWidth, double chordDistance) {
            this.start = start;
            this.end = end;
            this.planeBoundingOffset = planeBoundingOffset;
            this.arcWidth = arcWidth;
            this.chordDistance = chordDistance;
            this.fullDistance = start.arcDistance(end);
            this.fullNormalDistance = start.normalDistance(end);
            this.fullLinearDistance = start.linearDistance(end);
            this.normalizedConnectingPlane = new Plane((Vector)start, end).normalize();
            if (this.normalizedConnectingPlane == null) {
                this.upperConnectingPlane = null;
                this.lowerConnectingPlane = null;
                this.startCutoffPlane = null;
                this.endCutoffPlane = null;
                this.upperConnectingPlanePoints = null;
                this.lowerConnectingPlanePoints = null;
                this.startCutoffPlanePoints = null;
                this.endCutoffPlanePoints = null;
                this.invertedStartCutoffPlane = null;
                this.invertedEndCutoffPlane = null;
            } else {
                this.upperConnectingPlane = new SidedPlane((Vector)start, (Vector)this.normalizedConnectingPlane, -planeBoundingOffset);
                this.lowerConnectingPlane = new SidedPlane((Vector)start, (Vector)this.normalizedConnectingPlane, planeBoundingOffset);
                this.startCutoffPlane = new SidedPlane((Vector)end, (Vector)this.normalizedConnectingPlane, start);
                this.endCutoffPlane = new SidedPlane((Vector)start, (Vector)this.normalizedConnectingPlane, end);
                Membership[] upperSide = new Membership[]{this.upperConnectingPlane};
                Membership[] lowerSide = new Membership[]{this.lowerConnectingPlane};
                Membership[] startSide = new Membership[]{this.startCutoffPlane};
                Membership[] endSide = new Membership[]{this.endCutoffPlane};
                GeoPoint ULHC = this.upperConnectingPlane.findIntersections(this.startCutoffPlane, lowerSide, endSide)[0];
                GeoPoint URHC = this.upperConnectingPlane.findIntersections(this.endCutoffPlane, lowerSide, startSide)[0];
                GeoPoint LLHC = this.lowerConnectingPlane.findIntersections(this.startCutoffPlane, upperSide, endSide)[0];
                GeoPoint LRHC = this.lowerConnectingPlane.findIntersections(this.endCutoffPlane, upperSide, startSide)[0];
                this.upperConnectingPlanePoints = new GeoPoint[]{ULHC, URHC};
                this.lowerConnectingPlanePoints = new GeoPoint[]{LLHC, LRHC};
                this.startCutoffPlanePoints = new GeoPoint[]{ULHC, LLHC};
                this.endCutoffPlanePoints = new GeoPoint[]{URHC, LRHC};
                this.invertedStartCutoffPlane = new SidedPlane(this.startCutoffPlane);
                this.invertedEndCutoffPlane = new SidedPlane(this.endCutoffPlane);
            }
        }

        public boolean isDegenerate() {
            return this.normalizedConnectingPlane == null;
        }

        public boolean isWithin(Vector point) {
            return this.startCutoffPlane.isWithin(point) && this.endCutoffPlane.isWithin(point) && this.upperConnectingPlane.isWithin(point) && this.lowerConnectingPlane.isWithin(point);
        }

        public boolean isWithin(double x, double y, double z) {
            return this.startCutoffPlane.isWithin(x, y, z) && this.endCutoffPlane.isWithin(x, y, z) && this.upperConnectingPlane.isWithin(x, y, z) && this.lowerConnectingPlane.isWithin(x, y, z);
        }

        public double pathDistance(GeoPoint point) {
            if (!this.isWithin(point)) {
                return Double.MAX_VALUE;
            }
            double perpDistance = 1.5707963267948966 - Tools.safeAcos(Math.abs(this.normalizedConnectingPlane.evaluate(point)));
            Plane normalizedPerpPlane = new Plane((Vector)this.normalizedConnectingPlane, point).normalize();
            double pathDistance = 1.5707963267948966 - Tools.safeAcos(Math.abs(normalizedPerpPlane.evaluate(this.start)));
            return perpDistance + pathDistance;
        }

        public double pathNormalDistance(GeoPoint point) {
            if (!this.isWithin(point)) {
                return Double.MAX_VALUE;
            }
            double pointEval = Math.abs(this.normalizedConnectingPlane.evaluate(point));
            double perpX = this.normalizedConnectingPlane.y * point.z - this.normalizedConnectingPlane.z * point.y;
            double perpY = this.normalizedConnectingPlane.z * point.x - this.normalizedConnectingPlane.x * point.z;
            double perpZ = this.normalizedConnectingPlane.x * point.y - this.normalizedConnectingPlane.y * point.x;
            if (Math.abs(perpX) < 1.0E-12 && Math.abs(perpY) < 1.0E-12 && Math.abs(perpZ) < 1.0E-12) {
                return point.normalDistance(this.start);
            }
            double normFactor = 1.0 / Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            double perpEval = Math.abs(perpX * this.start.x + perpY * this.start.y + perpZ * this.start.z);
            return perpEval * normFactor + pointEval;
        }

        public double pathLinearDistance(GeoPoint point) {
            double normLineZ;
            double normLineY;
            if (!this.isWithin(point)) {
                return Double.MAX_VALUE;
            }
            double perpX = this.normalizedConnectingPlane.y * point.z - this.normalizedConnectingPlane.z * point.y;
            double perpY = this.normalizedConnectingPlane.z * point.x - this.normalizedConnectingPlane.x * point.z;
            double perpZ = this.normalizedConnectingPlane.x * point.y - this.normalizedConnectingPlane.y * point.x;
            if (Math.abs(perpX) < 1.0E-12 && Math.abs(perpY) < 1.0E-12 && Math.abs(perpZ) < 1.0E-12) {
                return point.linearDistance(this.start);
            }
            double lineX = this.normalizedConnectingPlane.y * perpZ - this.normalizedConnectingPlane.z * perpY;
            double lineY = this.normalizedConnectingPlane.z * perpX - this.normalizedConnectingPlane.x * perpZ;
            double lineZ = this.normalizedConnectingPlane.x * perpY - this.normalizedConnectingPlane.y * perpX;
            double normalizer = 1.0 / Math.sqrt(lineX * lineX + lineY * lineY + lineZ * lineZ);
            double normLineX = lineX * normalizer;
            if (!this.startCutoffPlane.isWithin(normLineX, normLineY = lineY * normalizer, normLineZ = lineZ * normalizer) || !this.endCutoffPlane.isWithin(normLineX, normLineY, normLineZ)) {
                normLineX = -normLineX;
                normLineY = -normLineY;
                normLineZ = -normLineZ;
            }
            return point.linearDistance(normLineX, normLineY, normLineZ) + this.start.linearDistance(normLineX, normLineY, normLineZ);
        }

        public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.upperConnectingPlane.intersects(p, notablePoints, this.upperConnectingPlanePoints, bounds, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane) || this.lowerConnectingPlane.intersects(p, notablePoints, this.lowerConnectingPlanePoints, bounds, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
        }

        public void getBounds(Bounds bounds) {
            bounds.addPoint(this.start).addPoint(this.end);
            this.upperConnectingPlane.recordBounds(this.startCutoffPlane, bounds, this.lowerConnectingPlane, this.endCutoffPlane);
            this.startCutoffPlane.recordBounds(this.lowerConnectingPlane, bounds, this.endCutoffPlane, this.upperConnectingPlane);
            this.lowerConnectingPlane.recordBounds(this.endCutoffPlane, bounds, this.upperConnectingPlane, this.startCutoffPlane);
            this.endCutoffPlane.recordBounds(this.upperConnectingPlane, bounds, this.startCutoffPlane, this.lowerConnectingPlane);
            this.upperConnectingPlane.recordBounds(bounds, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            this.lowerConnectingPlane.recordBounds(bounds, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            this.startCutoffPlane.recordBounds(bounds, this.endCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane);
            this.endCutoffPlane.recordBounds(bounds, this.startCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane);
            if (this.fullDistance >= Math.PI) {
                bounds.noLongitudeBound();
            }
        }
    }

    public static class SegmentEndpoint {
        public final GeoPoint point;
        public final SidedPlane circlePlane;
        public final double cutoffNormalDistance;
        public final double cutoffAngle;
        public final double chordDistance;
        public Membership[] cutoffPlanes = null;
        public GeoPoint[] notablePoints = null;
        public static final GeoPoint[] circlePoints = new GeoPoint[0];

        public SegmentEndpoint(GeoPoint point, double originDistance, double cutoffOffset, double cutoffAngle, double chordDistance) {
            this.point = point;
            this.cutoffNormalDistance = cutoffOffset;
            this.cutoffAngle = cutoffAngle;
            this.chordDistance = chordDistance;
            this.circlePlane = new SidedPlane((Vector)point, (Vector)point, -originDistance);
        }

        public void setCutoffPlanes(GeoPoint[] previousEndNotablePoints, Membership previousEndPlane, GeoPoint[] nextStartNotablePoints, Membership nextStartPlane) {
            if (previousEndNotablePoints == null && nextStartNotablePoints == null) {
                this.cutoffPlanes = new Membership[0];
                this.notablePoints = new GeoPoint[0];
            } else if (previousEndNotablePoints != null && nextStartNotablePoints == null) {
                this.cutoffPlanes = new Membership[]{previousEndPlane};
                this.notablePoints = previousEndNotablePoints;
            } else if (previousEndNotablePoints == null && nextStartNotablePoints != null) {
                this.cutoffPlanes = new Membership[]{nextStartPlane};
                this.notablePoints = nextStartNotablePoints;
            } else {
                this.cutoffPlanes = new Membership[]{previousEndPlane, nextStartPlane};
                this.notablePoints = new GeoPoint[previousEndNotablePoints.length + nextStartNotablePoints.length];
                int i = 0;
                for (GeoPoint p : previousEndNotablePoints) {
                    this.notablePoints[i++] = p;
                }
                for (GeoPoint p : nextStartNotablePoints) {
                    this.notablePoints[i++] = p;
                }
            }
        }

        public boolean isWithin(Vector point) {
            return this.circlePlane.isWithin(point);
        }

        public boolean isWithin(double x, double y, double z) {
            return this.circlePlane.isWithin(x, y, z);
        }

        public double pathDistance(GeoPoint point) {
            double dist = this.point.arcDistance(point);
            if (dist > this.cutoffAngle) {
                return Double.MAX_VALUE;
            }
            return dist;
        }

        public double pathNormalDistance(GeoPoint point) {
            double dist = this.point.normalDistance(point);
            if (dist > this.cutoffNormalDistance) {
                return Double.MAX_VALUE;
            }
            return dist;
        }

        public double pathLinearDistance(GeoPoint point) {
            double dist = this.point.linearDistance(point);
            if (dist > this.chordDistance) {
                return Double.MAX_VALUE;
            }
            return dist;
        }

        public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.circlePlane.intersects(p, notablePoints, this.notablePoints, bounds, this.cutoffPlanes);
        }

        public void getBounds(Bounds bounds) {
            bounds.addPoint(this.point);
            this.circlePlane.recordBounds(bounds, new Membership[0]);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SegmentEndpoint)) {
                return false;
            }
            SegmentEndpoint other = (SegmentEndpoint)o;
            return this.point.equals(other.point);
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public String toString() {
            return this.point.toString();
        }
    }
}

