/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoDegenerateVerticalLine
extends GeoBBoxBase {
    public final double topLat;
    public final double bottomLat;
    public final double longitude;
    public final GeoPoint UHC;
    public final GeoPoint LHC;
    public final SidedPlane topPlane;
    public final SidedPlane bottomPlane;
    public final SidedPlane boundingPlane;
    public final Plane plane;
    public final GeoPoint[] planePoints;
    public final GeoPoint centerPoint;
    public final GeoPoint[] edgePoints;

    public GeoDegenerateVerticalLine(double topLat, double bottomLat, double longitude) {
        if (topLat > 1.5707963267948966 || topLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Top latitude out of range");
        }
        if (bottomLat > 1.5707963267948966 || bottomLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Bottom latitude out of range");
        }
        if (topLat < bottomLat) {
            throw new IllegalArgumentException("Top latitude less than bottom latitude");
        }
        if (longitude < -Math.PI || longitude > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        this.topLat = topLat;
        this.bottomLat = bottomLat;
        this.longitude = longitude;
        double sinTopLat = Math.sin(topLat);
        double cosTopLat = Math.cos(topLat);
        double sinBottomLat = Math.sin(bottomLat);
        double cosBottomLat = Math.cos(bottomLat);
        double sinLongitude = Math.sin(longitude);
        double cosLongitude = Math.cos(longitude);
        this.UHC = new GeoPoint(sinTopLat, sinLongitude, cosTopLat, cosLongitude);
        this.LHC = new GeoPoint(sinBottomLat, sinLongitude, cosBottomLat, cosLongitude);
        this.plane = new Plane(cosLongitude, sinLongitude);
        double middleLat = (topLat + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        double cosMiddleLat = Math.cos(middleLat);
        this.centerPoint = new GeoPoint(sinMiddleLat, sinLongitude, cosMiddleLat, cosLongitude);
        this.topPlane = new SidedPlane((Vector)this.centerPoint, sinTopLat);
        this.bottomPlane = new SidedPlane((Vector)this.centerPoint, sinBottomLat);
        this.boundingPlane = new SidedPlane((Vector)this.centerPoint, -sinLongitude, cosLongitude);
        this.planePoints = new GeoPoint[]{this.UHC, this.LHC};
        this.edgePoints = new GeoPoint[]{this.centerPoint};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.topLat + angle;
        double newBottomLat = this.bottomLat - angle;
        double newLeftLon = this.longitude - angle;
        double newRightLon = this.longitude + angle;
        double currentLonSpan = 2.0 * angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(newTopLat, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.plane.evaluateIsZero(point) && this.boundingPlane.isWithin(point) && this.topPlane.isWithin(point) && this.bottomPlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.plane.evaluateIsZero(x, y, z) && this.boundingPlane.isWithin(x, y, z) && this.topPlane.isWithin(x, y, z) && this.bottomPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double topAngle = this.centerPoint.arcDistance(this.UHC);
        double bottomAngle = this.centerPoint.arcDistance(this.LHC);
        return Math.max(topAngle, bottomAngle);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.plane, notablePoints, this.planePoints, bounds, this.boundingPlane, this.topPlane, this.bottomPlane);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.addLatitudeZone(this.topLat).addLatitudeZone(this.bottomLat).addLongitudeSlice(this.longitude, this.longitude);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (path.intersects(this.plane, this.planePoints, this.boundingPlane, this.topPlane, this.bottomPlane)) {
            return 2;
        }
        if (path.isWithin(this.centerPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateVerticalLine)) {
            return false;
        }
        GeoDegenerateVerticalLine other = (GeoDegenerateVerticalLine)o;
        return other.UHC.equals(this.UHC) && other.LHC.equals(this.LHC);
    }

    public int hashCode() {
        int result = this.UHC.hashCode();
        result = 31 * result + this.LHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoDegenerateVerticalLine: {longitude=" + this.longitude + "(" + this.longitude * 180.0 / Math.PI + "), toplat=" + this.topLat + "(" + this.topLat * 180.0 / Math.PI + "), bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + ")}";
    }
}

