/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoMembershipShape;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoCompositeMembershipShape
implements GeoMembershipShape {
    protected final List<GeoMembershipShape> shapes = new ArrayList<GeoMembershipShape>();

    public void addShape(GeoMembershipShape shape) {
        this.shapes.add(shape);
    }

    @Override
    public boolean isWithin(Vector point) {
        for (GeoMembershipShape shape : this.shapes) {
            if (!shape.isWithin(point)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (GeoMembershipShape shape : this.shapes) {
            if (!shape.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.shapes.get(0).getEdgePoints();
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (GeoMembershipShape shape : this.shapes) {
            if (!shape.intersects(p, notablePoints, bounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        for (GeoMembershipShape shape : this.shapes) {
            bounds = shape.getBounds(bounds);
        }
        return bounds;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoCompositeMembershipShape)) {
            return false;
        }
        GeoCompositeMembershipShape other = (GeoCompositeMembershipShape)o;
        if (other.shapes.size() != this.shapes.size()) {
            return false;
        }
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (other.shapes.get(i).equals(this.shapes.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.shapes.hashCode();
    }

    public String toString() {
        return "GeoCompositeMembershipShape: {" + this.shapes + '}';
    }
}

