/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;

public class PrefixTreeFacetCounter {
    private PrefixTreeFacetCounter() {
    }

    public static void compute(PrefixTreeStrategy strategy, IndexReaderContext context, Filter filter, Shape queryShape, int facetLevel, FacetVisitor facetVisitor) throws IOException {
        for (LeafReaderContext leafCtx : context.leaves()) {
            Bits leafAcceptDocs;
            if (filter == null) {
                leafAcceptDocs = leafCtx.reader().getLiveDocs();
            } else {
                DocIdSet docIdSet = filter.getDocIdSet(leafCtx, leafCtx.reader().getLiveDocs());
                if (docIdSet == null) continue;
                leafAcceptDocs = docIdSet.bits();
                if (leafAcceptDocs == null) {
                    DocIdSetIterator iterator = docIdSet.iterator();
                    if (iterator == null) continue;
                    SparseFixedBitSet bitSet = new SparseFixedBitSet(leafCtx.reader().maxDoc());
                    bitSet.or(iterator);
                    leafAcceptDocs = bitSet;
                }
            }
            PrefixTreeFacetCounter.compute(strategy, leafCtx, leafAcceptDocs, queryShape, facetLevel, facetVisitor);
        }
    }

    public static void compute(PrefixTreeStrategy strategy, LeafReaderContext context, Bits acceptDocs, Shape queryShape, final int facetLevel, final FacetVisitor facetVisitor) throws IOException {
        if (acceptDocs != null && acceptDocs.length() != context.reader().maxDoc()) {
            throw new IllegalArgumentException("acceptDocs bits length " + acceptDocs.length() + " != leaf maxdoc " + context.reader().maxDoc());
        }
        SpatialPrefixTree tree = strategy.getGrid();
        int scanLevel = tree.getMaxLevels();
        new AbstractVisitingPrefixTreeFilter(queryShape, strategy.getFieldName(), tree, facetLevel, scanLevel){

            public String toString(String field) {
                return "anonPrefixTreeFilter";
            }

            public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
                assert (facetLevel == this.detailLevel);
                return new AbstractVisitingPrefixTreeFilter.VisitorTemplate(context, acceptDocs){

                    @Override
                    protected void start() throws IOException {
                        facetVisitor.startOfSegment();
                    }

                    @Override
                    protected DocIdSet finish() throws IOException {
                        return null;
                    }

                    @Override
                    protected boolean visitPrefix(Cell cell) throws IOException {
                        if (cell.getLevel() == facetLevel) {
                            this.visitLeaf(cell);
                            return false;
                        }
                        return cell.getLevel() != facetLevel - 1 && this.termsEnum.docFreq() != 1 || this.hasDocsAtThisTerm();
                    }

                    @Override
                    protected void visitLeaf(Cell cell) throws IOException {
                        int count = this.countDocsAtThisTerm();
                        if (count > 0) {
                            facetVisitor.visit(cell, count);
                        }
                    }

                    private int countDocsAtThisTerm() throws IOException {
                        if (this.acceptDocs == null) {
                            return this.termsEnum.docFreq();
                        }
                        int count = 0;
                        this.postingsEnum = this.termsEnum.postings(this.acceptDocs, this.postingsEnum, 0);
                        while (this.postingsEnum.nextDoc() != Integer.MAX_VALUE) {
                            ++count;
                        }
                        return count;
                    }

                    private boolean hasDocsAtThisTerm() throws IOException {
                        if (this.acceptDocs == null) {
                            return true;
                        }
                        this.postingsEnum = this.termsEnum.postings(this.acceptDocs, this.postingsEnum, 0);
                        return this.postingsEnum.nextDoc() != Integer.MAX_VALUE;
                    }
                }.getDocIdSet();
            }
        }.getDocIdSet(context, acceptDocs);
    }

    public static abstract class FacetVisitor {
        public void startOfSegment() {
        }

        public abstract void visit(Cell var1, int var2);
    }
}

