/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class SidedPlane
extends Plane
implements Membership {
    public final double sigNum;

    public SidedPlane(SidedPlane sidedPlane) {
        super((Vector)sidedPlane, sidedPlane.D);
        this.sigNum = -sidedPlane.sigNum;
    }

    public SidedPlane(Vector p, Vector A, Vector B) {
        super(A, B);
        this.sigNum = Math.signum(this.evaluate(p));
    }

    public SidedPlane(Vector p, double height) {
        super(height);
        this.sigNum = Math.signum(this.evaluate(p));
    }

    public SidedPlane(Vector p, double x, double y) {
        super(x, y);
        this.sigNum = Math.signum(this.evaluate(p));
    }

    public SidedPlane(Vector p, Vector v, double D) {
        super(v, D);
        this.sigNum = Math.signum(this.evaluate(p));
    }

    @Override
    public boolean isWithin(Vector point) {
        double evalResult = this.evaluate(point);
        if (Math.abs(evalResult) < 1.0E-12) {
            return true;
        }
        double sigNum = Math.signum(evalResult);
        return sigNum == this.sigNum;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        double evalResult = this.evaluate(x, y, z);
        if (Math.abs(evalResult) < 1.0E-12) {
            return true;
        }
        double sigNum = Math.signum(evalResult);
        return sigNum == this.sigNum;
    }

    @Override
    public String toString() {
        return "[A=" + this.x + ", B=" + this.y + ", C=" + this.z + ", D=" + this.D + ", side=" + this.sigNum + "]";
    }
}

