/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.CellTokenStream;
import org.apache.lucene.spatial.prefix.ContainsPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.IntersectsPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.WithinPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.LegacyCell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;

public class RecursivePrefixTreeStrategy
extends PrefixTreeStrategy {
    protected int prefixGridScanLevel;
    protected boolean pruneLeafyBranches = true;
    protected boolean pointsOnly = false;
    protected boolean multiOverlappingIndexedShapes = true;

    public RecursivePrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName);
        this.prefixGridScanLevel = grid.getMaxLevels() - 4;
    }

    public void setPrefixGridScanLevel(int prefixGridScanLevel) {
        this.prefixGridScanLevel = prefixGridScanLevel;
    }

    public void setPointsOnly(boolean pointsOnly) {
        this.pointsOnly = pointsOnly;
    }

    public void setMultiOverlappingIndexedShapes(boolean multiOverlappingIndexedShapes) {
        this.multiOverlappingIndexedShapes = multiOverlappingIndexedShapes;
    }

    public void setPruneLeafyBranches(boolean pruneLeafyBranches) {
        this.pruneLeafyBranches = pruneLeafyBranches;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName()).append('(');
        str.append("SPG:(").append(this.grid.toString()).append(')');
        if (this.pointsOnly) {
            str.append(",pointsOnly");
        }
        if (this.pruneLeafyBranches) {
            str.append(",pruneLeafyBranches");
        }
        if (this.prefixGridScanLevel != this.grid.getMaxLevels() - 4) {
            str.append(",prefixGridScanLevel:").append("" + this.prefixGridScanLevel);
        }
        if (!this.multiOverlappingIndexedShapes) {
            str.append(",!multiOverlappingIndexedShapes");
        }
        return str.append(')').toString();
    }

    @Override
    protected TokenStream createTokenStream(Shape shape, int detailLevel) {
        if (shape instanceof Point || !this.pruneLeafyBranches) {
            return super.createTokenStream(shape, detailLevel);
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(4096);
        this.recursiveTraverseAndPrune(this.grid.getWorldCell(), shape, detailLevel, cells);
        return new CellTokenStream().setCells(cells.iterator());
    }

    private boolean recursiveTraverseAndPrune(Cell cell, Shape shape, int detailLevel, List<Cell> result) {
        if (!(cell instanceof LegacyCell)) {
            throw new IllegalStateException("pruneLeafyBranches must be disabled for use with grid " + this.grid);
        }
        if (cell.getLevel() == detailLevel) {
            cell.setLeaf();
        }
        if (cell.isLeaf()) {
            result.add(cell);
            return true;
        }
        if (cell.getLevel() != 0) {
            result.add(cell);
        }
        int leaves = 0;
        CellIterator subCells = cell.getNextLevelCells(shape);
        while (subCells.hasNext()) {
            Cell subCell = subCells.next();
            if (!this.recursiveTraverseAndPrune(subCell, shape, detailLevel, result)) continue;
            ++leaves;
        }
        if (leaves == ((LegacyCell)cell).getSubCellsSize() && cell.getLevel() != 0) {
            do {
                result.remove(result.size() - 1);
            } while (--leaves > 0);
            cell.setLeaf();
            return true;
        }
        return false;
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        if (this.pointsOnly || op == SpatialOperation.Intersects) {
            return new IntersectsPrefixTreeFilter(shape, this.getFieldName(), this.grid, detailLevel, this.prefixGridScanLevel, !this.pointsOnly);
        }
        if (op == SpatialOperation.IsWithin) {
            return new WithinPrefixTreeFilter(shape, this.getFieldName(), this.grid, detailLevel, this.prefixGridScanLevel, -1.0);
        }
        if (op == SpatialOperation.Contains) {
            return new ContainsPrefixTreeFilter(shape, this.getFieldName(), this.grid, detailLevel, this.multiOverlappingIndexedShapes);
        }
        throw new UnsupportedSpatialOperation(op);
    }
}

