/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;

public class NumberRangePrefixTreeStrategy
extends RecursivePrefixTreeStrategy {
    public NumberRangePrefixTreeStrategy(NumberRangePrefixTree prefixTree, String fieldName) {
        super(prefixTree, fieldName);
        this.setPruneLeafyBranches(false);
        this.setPrefixGridScanLevel(prefixTree.getMaxLevels() - 2);
        this.setPointsOnly(false);
        this.setDistErrPct(0.0);
    }

    @Override
    public NumberRangePrefixTree getGrid() {
        return (NumberRangePrefixTree)super.getGrid();
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        TokenStream tokenStream = this.createTokenStream(shape, this.grid.getMaxLevels());
        Field field = new Field(this.getFieldName(), tokenStream, FIELD_TYPE);
        return new Field[]{field};
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        throw new UnsupportedOperationException();
    }
}

