/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;

class CellTokenStream
extends TokenStream {
    private final CellTermAttribute cellAtt;
    private Iterator<Cell> iter;

    public CellTokenStream() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
    }

    public CellTokenStream(AttributeFactory factory) {
        super((AttributeFactory)new CellAttributeFactory(factory));
        this.addAttributeImpl(new CellTermAttributeImpl());
        this.cellAtt = (CellTermAttribute)this.addAttribute(CellTermAttribute.class);
        this.iter = null;
    }

    public CellTokenStream setCells(Iterator<Cell> iter) {
        this.iter = iter;
        return this;
    }

    public void reset() throws IOException {
        if (this.iter == null) {
            throw new IllegalStateException("call setCells() before usage");
        }
        this.cellAtt.setCell(null);
        this.cellAtt.setOmitLeafByte(false);
    }

    public final boolean incrementToken() {
        if (this.iter == null) {
            throw new IllegalStateException("call setCells() before usage");
        }
        this.clearAttributes();
        if (this.cellAtt.getOmitLeafByte()) {
            this.cellAtt.setOmitLeafByte(false);
            return true;
        }
        if (!this.iter.hasNext()) {
            return false;
        }
        this.cellAtt.setCell(this.iter.next());
        if (this.cellAtt.getCell().isLeaf()) {
            this.cellAtt.setOmitLeafByte(true);
        }
        return true;
    }

    private static final class CellTermAttributeImpl
    extends AttributeImpl
    implements CellTermAttribute,
    TermToBytesRefAttribute {
        private BytesRef bytes = new BytesRef();
        private Cell cell;
        private boolean omitLeafByte;

        private CellTermAttributeImpl() {
        }

        @Override
        public Cell getCell() {
            return this.cell;
        }

        @Override
        public boolean getOmitLeafByte() {
            return this.omitLeafByte;
        }

        @Override
        public void setCell(Cell cell) {
            this.cell = cell;
            this.omitLeafByte = false;
        }

        @Override
        public void setOmitLeafByte(boolean b) {
            this.omitLeafByte = b;
        }

        public void clear() {
        }

        public void copyTo(AttributeImpl target) {
            CellTermAttribute a = (CellTermAttribute)target;
            a.setCell(this.cell);
            a.setOmitLeafByte(this.omitLeafByte);
        }

        public void fillBytesRef() {
            if (this.omitLeafByte) {
                this.cell.getTokenBytesNoLeaf(this.bytes);
            } else {
                this.cell.getTokenBytesWithLeaf(this.bytes);
            }
        }

        public BytesRef getBytesRef() {
            return this.bytes;
        }

        public void reflectWith(AttributeReflector reflector) {
            this.fillBytesRef();
            reflector.reflect(TermToBytesRefAttribute.class, "bytes", (Object)BytesRef.deepCopyOf((BytesRef)this.bytes));
        }

        public CellTermAttributeImpl clone() {
            CellTermAttributeImpl clone = (CellTermAttributeImpl)super.clone();
            clone.bytes = BytesRef.deepCopyOf((BytesRef)this.bytes);
            return clone;
        }

        public int hashCode() {
            return Objects.hash(this.cell, this.omitLeafByte);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellTermAttributeImpl other = (CellTermAttributeImpl)obj;
            if (this.cell == null ? other.cell != null : !this.cell.equals(other.cell)) {
                return false;
            }
            return this.omitLeafByte == other.omitLeafByte;
        }
    }

    private static final class CellAttributeFactory
    extends AttributeFactory {
        private final AttributeFactory delegate;

        CellAttributeFactory(AttributeFactory delegate) {
            this.delegate = delegate;
        }

        public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                throw new IllegalArgumentException("CellTokenStream does not support CharTermAttribute.");
            }
            return this.delegate.createAttributeInstance(attClass);
        }
    }

    private static interface CellTermAttribute
    extends Attribute {
        public Cell getCell();

        public void setCell(Cell var1);

        public boolean getOmitLeafByte();

        public void setOmitLeafByte(boolean var1);
    }
}

