/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SpatialOperation
implements Serializable {
    private static final Map<String, SpatialOperation> registry = new HashMap<String, SpatialOperation>();
    private static final List<SpatialOperation> list = new ArrayList<SpatialOperation>();
    public static final SpatialOperation BBoxIntersects = new SpatialOperation("BBoxIntersects", true, false, false);
    public static final SpatialOperation BBoxWithin = new SpatialOperation("BBoxWithin", true, false, false);
    public static final SpatialOperation Contains = new SpatialOperation("Contains", true, true, false);
    public static final SpatialOperation Intersects = new SpatialOperation("Intersects", true, false, false);
    public static final SpatialOperation IsEqualTo = new SpatialOperation("IsEqualTo", false, false, false);
    public static final SpatialOperation IsDisjointTo = new SpatialOperation("IsDisjointTo", false, false, false);
    public static final SpatialOperation IsWithin = new SpatialOperation("IsWithin", true, false, true);
    public static final SpatialOperation Overlaps = new SpatialOperation("Overlaps", true, false, true);
    private final boolean scoreIsMeaningful;
    private final boolean sourceNeedsArea;
    private final boolean targetNeedsArea;
    private final String name;

    protected SpatialOperation(String name, boolean scoreIsMeaningful, boolean sourceNeedsArea, boolean targetNeedsArea) {
        this.name = name;
        this.scoreIsMeaningful = scoreIsMeaningful;
        this.sourceNeedsArea = sourceNeedsArea;
        this.targetNeedsArea = targetNeedsArea;
        registry.put(name, this);
        registry.put(name.toUpperCase(Locale.ROOT), this);
        list.add(this);
    }

    public static SpatialOperation get(String v) {
        SpatialOperation op = registry.get(v);
        if (op == null) {
            op = registry.get(v.toUpperCase(Locale.ROOT));
        }
        if (op == null) {
            throw new IllegalArgumentException("Unknown Operation: " + v);
        }
        return op;
    }

    public static List<SpatialOperation> values() {
        return list;
    }

    public static boolean is(SpatialOperation op, SpatialOperation ... tst) {
        for (SpatialOperation t : tst) {
            if (op != t) continue;
            return true;
        }
        return false;
    }

    public boolean isScoreIsMeaningful() {
        return this.scoreIsMeaningful;
    }

    public boolean isSourceNeedsArea() {
        return this.sourceNeedsArea;
    }

    public boolean isTargetNeedsArea() {
        return this.targetNeedsArea;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

