/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.shape.Point;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.spatial.vector.TwoDoublesStrategy;
import org.apache.lucene.util.Bits;

public class DistanceValueSource
extends ValueSource {
    private TwoDoublesStrategy strategy;
    private final Point from;
    private final DistanceCalculator calculator;

    public DistanceValueSource(TwoDoublesStrategy strategy, Point from, DistanceCalculator calc) {
        this.strategy = strategy;
        this.from = from;
        this.calculator = calc;
    }

    public String description() {
        return "DistanceValueSource(" + this.calculator + ")";
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        AtomicReader reader = readerContext.reader();
        final double[] ptX = FieldCache.DEFAULT.getDoubles(reader, this.strategy.getFieldNameX(), true);
        final double[] ptY = FieldCache.DEFAULT.getDoubles(reader, this.strategy.getFieldNameY(), true);
        final Bits validX = FieldCache.DEFAULT.getDocsWithField(reader, this.strategy.getFieldNameX());
        final Bits validY = FieldCache.DEFAULT.getDocsWithField(reader, this.strategy.getFieldNameY());
        return new FunctionValues(){

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                if (validX.get(doc) && validY.get(doc)) {
                    return DistanceValueSource.this.calculator.distance(DistanceValueSource.this.from, ptX[doc], ptY[doc]);
                }
                return 0.0;
            }

            public String toString(int doc) {
                return DistanceValueSource.this.description() + "=" + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistanceValueSource that = (DistanceValueSource)((Object)o);
        if (this.calculator != null ? !this.calculator.equals(that.calculator) : that.calculator != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.from != null ? !this.from.equals(that.from) : that.from != null);
    }

    public int hashCode() {
        int result = this.strategy != null ? this.strategy.hashCode() : 0;
        result = 31 * result + (this.calculator != null ? this.calculator.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }
}

