/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.query;

import com.spatial4j.core.exception.InvalidSpatialArgument;
import com.spatial4j.core.shape.Shape;
import java.util.Locale;
import org.apache.lucene.spatial.query.SpatialOperation;

public class SpatialArgs {
    public static final double DEFAULT_DIST_PRECISION = 0.025;
    private SpatialOperation operation;
    private Shape shape;
    private double distPrecision = 0.025;
    private Double min;
    private Double max;

    public SpatialArgs(SpatialOperation operation) {
        this.operation = operation;
    }

    public SpatialArgs(SpatialOperation operation, Shape shape) {
        this.operation = operation;
        this.shape = shape;
    }

    public void validate() throws InvalidSpatialArgument {
        if (this.operation.isTargetNeedsArea() && !this.shape.hasArea()) {
            throw new InvalidSpatialArgument(this.operation + " only supports geometry with area");
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.operation.getName()).append('(');
        str.append(this.shape.toString());
        if (this.min != null) {
            str.append(" min=").append(this.min);
        }
        if (this.max != null) {
            str.append(" max=").append(this.max);
        }
        str.append(" distPrec=").append(String.format(Locale.ROOT, "%.2f%%", this.distPrecision / 100.0));
        str.append(')');
        return str.toString();
    }

    public SpatialOperation getOperation() {
        return this.operation;
    }

    public void setOperation(SpatialOperation operation) {
        this.operation = operation;
    }

    public Shape getShape() {
        if (this.shape != null && (this.operation == SpatialOperation.BBoxWithin || this.operation == SpatialOperation.BBoxIntersects)) {
            return this.shape.getBoundingBox();
        }
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Double getDistPrecision() {
        return this.distPrecision;
    }

    public void setDistPrecision(Double distPrecision) {
        if (distPrecision != null) {
            this.distPrecision = distPrecision;
        }
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
    }
}

