/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Node;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;

public class TermQueryPrefixTreeStrategy
extends PrefixTreeStrategy {
    public TermQueryPrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName);
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        if (!SpatialOperation.is(op, SpatialOperation.IsWithin, SpatialOperation.Intersects, SpatialOperation.BBoxWithin, SpatialOperation.BBoxIntersects)) {
            throw new UnsupportedSpatialOperation(op);
        }
        Shape shape = args.getShape();
        int detailLevel = this.grid.getMaxLevelForPrecision(shape, args.getDistPrecision());
        List<Node> cells = this.grid.getNodes(shape, detailLevel, false);
        TermsFilter filter = new TermsFilter();
        for (Node cell : cells) {
            filter.addTerm(new Term(this.getFieldName(), cell.getTokenString()));
        }
        return filter;
    }
}

