/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.query.SpatialArgs;

public abstract class SpatialStrategy {
    protected boolean ignoreIncompatibleGeometry = false;
    protected final SpatialContext ctx;
    private final String fieldName;

    public SpatialStrategy(SpatialContext ctx, String fieldName) {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is required");
        }
        this.ctx = ctx;
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("fieldName is required");
        }
        this.fieldName = fieldName;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public abstract IndexableField[] createIndexableFields(Shape var1);

    public abstract ValueSource makeValueSource(SpatialArgs var1);

    public Query makeQuery(SpatialArgs args) {
        Filter filter = this.makeFilter(args);
        ValueSource vs = this.makeValueSource(args);
        return new FilteredQuery((Query)new FunctionQuery(vs), filter);
    }

    public abstract Filter makeFilter(SpatialArgs var1);

    public boolean isIgnoreIncompatibleGeometry() {
        return this.ignoreIncompatibleGeometry;
    }

    public void setIgnoreIncompatibleGeometry(boolean ignoreIncompatibleGeometry) {
        this.ignoreIncompatibleGeometry = ignoreIncompatibleGeometry;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " field:" + this.fieldName + " ctx=" + this.ctx;
    }
}

