/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.exception.UnsupportedSpatialOperation;
import com.spatial4j.core.query.SpatialArgs;
import com.spatial4j.core.query.SpatialOperation;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.util.CachingDoubleValueSource;
import org.apache.lucene.spatial.util.NumericFieldInfo;
import org.apache.lucene.spatial.util.ValueSourceFilter;
import org.apache.lucene.spatial.vector.DistanceValueSource;
import org.apache.lucene.spatial.vector.TwoDoublesFieldInfo;

public class TwoDoublesStrategy
extends SpatialStrategy<TwoDoublesFieldInfo> {
    private final NumericFieldInfo finfo;
    private final FieldCache.DoubleParser parser;

    public TwoDoublesStrategy(SpatialContext ctx, NumericFieldInfo finfo, FieldCache.DoubleParser parser) {
        super(ctx);
        this.finfo = finfo;
        this.parser = parser;
    }

    @Override
    public boolean isPolyField() {
        return true;
    }

    @Override
    public IndexableField[] createFields(TwoDoublesFieldInfo fieldInfo, Shape shape, boolean index, boolean store) {
        if (shape instanceof Point) {
            Point point = (Point)shape;
            IndexableField[] f = new IndexableField[(index ? 2 : 0) + (store ? 1 : 0)];
            if (index) {
                f[0] = this.finfo.createDouble(fieldInfo.getFieldNameX(), point.getX());
                f[1] = this.finfo.createDouble(fieldInfo.getFieldNameY(), point.getY());
            }
            if (store) {
                FieldType customType = new FieldType();
                customType.setStored(true);
                f[f.length - 1] = new Field(fieldInfo.getFieldName(), this.ctx.toString(shape), customType);
            }
            return f;
        }
        if (!this.ignoreIncompatibleGeometry) {
            throw new IllegalArgumentException("TwoDoublesStrategy can not index: " + shape);
        }
        return new IndexableField[0];
    }

    @Override
    public IndexableField createField(TwoDoublesFieldInfo indexInfo, Shape shape, boolean index, boolean store) {
        throw new UnsupportedOperationException("Point is poly field");
    }

    @Override
    public ValueSource makeValueSource(SpatialArgs args, TwoDoublesFieldInfo fieldInfo) {
        Point p = args.getShape().getCenter();
        return new DistanceValueSource(p, this.ctx.getDistCalc(), fieldInfo, this.parser);
    }

    @Override
    public Filter makeFilter(SpatialArgs args, TwoDoublesFieldInfo fieldInfo) {
        if (args.getShape() instanceof Circle && SpatialOperation.is((SpatialOperation)args.getOperation(), (SpatialOperation[])new SpatialOperation[]{SpatialOperation.Intersects, SpatialOperation.IsWithin})) {
            Circle circle = (Circle)args.getShape();
            Query bbox = this.makeWithin(circle.getBoundingBox(), fieldInfo);
            ValueSource valueSource = this.makeValueSource(args, fieldInfo);
            return new ValueSourceFilter((Filter)new QueryWrapperFilter(bbox), valueSource, 0.0, circle.getDistance());
        }
        return new QueryWrapperFilter(this.makeQuery(args, fieldInfo));
    }

    @Override
    public Query makeQuery(SpatialArgs args, TwoDoublesFieldInfo fieldInfo) {
        Shape shape = args.getShape();
        if (!(shape instanceof Rectangle)) {
            throw new InvalidShapeException("A rectangle is the only supported shape (so far), not " + shape.getClass());
        }
        Rectangle bbox = (Rectangle)shape;
        if (bbox.getCrossesDateLine()) {
            throw new UnsupportedOperationException("Crossing dateline not yet supported");
        }
        CachingDoubleValueSource valueSource = null;
        Query spatial = null;
        SpatialOperation op = args.getOperation();
        if (SpatialOperation.is((SpatialOperation)op, (SpatialOperation[])new SpatialOperation[]{SpatialOperation.BBoxWithin, SpatialOperation.BBoxIntersects})) {
            spatial = this.makeWithin(bbox, fieldInfo);
        } else if (SpatialOperation.is((SpatialOperation)op, (SpatialOperation[])new SpatialOperation[]{SpatialOperation.Intersects, SpatialOperation.IsWithin})) {
            spatial = this.makeWithin(bbox, fieldInfo);
            if (args.getShape() instanceof Circle) {
                Circle circle = (Circle)args.getShape();
                valueSource = this.makeValueSource(args, fieldInfo);
                ValueSourceFilter vsf = new ValueSourceFilter((Filter)new QueryWrapperFilter(spatial), valueSource, 0.0, circle.getDistance());
                spatial = new FilteredQuery((Query)new MatchAllDocsQuery(), (Filter)vsf);
            }
        } else if (op == SpatialOperation.IsDisjointTo) {
            spatial = this.makeDisjoint(bbox, fieldInfo);
        }
        if (spatial == null) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        valueSource = valueSource != null ? new CachingDoubleValueSource(valueSource) : this.makeValueSource(args, fieldInfo);
        FunctionQuery spatialRankingQuery = new FunctionQuery((ValueSource)valueSource);
        BooleanQuery bq = new BooleanQuery();
        bq.add(spatial, BooleanClause.Occur.MUST);
        bq.add((Query)spatialRankingQuery, BooleanClause.Occur.MUST);
        return bq;
    }

    private Query makeWithin(Rectangle bbox, TwoDoublesFieldInfo fieldInfo) {
        NumericRangeQuery qX = NumericRangeQuery.newDoubleRange((String)fieldInfo.getFieldNameX(), (int)this.finfo.precisionStep, (Double)bbox.getMinX(), (Double)bbox.getMaxX(), (boolean)true, (boolean)true);
        NumericRangeQuery qY = NumericRangeQuery.newDoubleRange((String)fieldInfo.getFieldNameY(), (int)this.finfo.precisionStep, (Double)bbox.getMinY(), (Double)bbox.getMaxY(), (boolean)true, (boolean)true);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)qX, BooleanClause.Occur.MUST);
        bq.add((Query)qY, BooleanClause.Occur.MUST);
        return bq;
    }

    Query makeDisjoint(Rectangle bbox, TwoDoublesFieldInfo fieldInfo) {
        NumericRangeQuery qX = NumericRangeQuery.newDoubleRange((String)fieldInfo.getFieldNameX(), (int)this.finfo.precisionStep, (Double)bbox.getMinX(), (Double)bbox.getMaxX(), (boolean)true, (boolean)true);
        NumericRangeQuery qY = NumericRangeQuery.newDoubleRange((String)fieldInfo.getFieldNameY(), (int)this.finfo.precisionStep, (Double)bbox.getMinY(), (Double)bbox.getMaxY(), (boolean)true, (boolean)true);
        BooleanQuery bq = new BooleanQuery();
        bq.add((Query)qX, BooleanClause.Occur.MUST_NOT);
        bq.add((Query)qY, BooleanClause.Occur.MUST_NOT);
        return bq;
    }
}

