/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.tree.Node;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.StringHelper;

public class RecursivePrefixTreeFilter
extends Filter {
    private final String fieldName;
    private final SpatialPrefixTree grid;
    private final Shape queryShape;
    private final int prefixGridScanLevel;
    private final int detailLevel;

    public RecursivePrefixTreeFilter(String fieldName, SpatialPrefixTree grid, Shape queryShape, int prefixGridScanLevel, int detailLevel) {
        this.fieldName = fieldName;
        this.grid = grid;
        this.queryShape = queryShape;
        this.prefixGridScanLevel = Math.max(1, Math.min(prefixGridScanLevel, grid.getMaxLevels() - 1));
        this.detailLevel = detailLevel;
        assert (detailLevel <= grid.getMaxLevels());
    }

    public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits acceptDocs) throws IOException {
        Node cell;
        BytesRef cellTerm;
        TermsEnum.SeekStatus seekStat;
        AtomicReader reader = ctx.reader();
        OpenBitSet bits = new OpenBitSet((long)reader.maxDoc());
        Terms terms = reader.terms(this.fieldName);
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = terms.iterator(null);
        DocsEnum docsEnum = null;
        Node scanCell = null;
        LinkedList<Node> cells = new LinkedList<Node>(this.grid.getWorldNode().getSubCells(this.queryShape));
        while (!cells.isEmpty() && (seekStat = termsEnum.seekCeil(cellTerm = new BytesRef((cell = cells.removeFirst()).getTokenBytes()))) != TermsEnum.SeekStatus.END) {
            boolean scan;
            if (seekStat == TermsEnum.SeekStatus.NOT_FOUND) continue;
            if (cell.getLevel() == this.detailLevel || cell.isLeaf()) {
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, false);
                this.addDocs(docsEnum, bits);
                continue;
            }
            BytesRef nextCellTerm = termsEnum.next();
            assert (StringHelper.startsWith((BytesRef)nextCellTerm, (BytesRef)cellTerm));
            if ((scanCell = this.grid.getNode(nextCellTerm.bytes, nextCellTerm.offset, nextCellTerm.length, scanCell)).isLeaf()) {
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, false);
                this.addDocs(docsEnum, bits);
                termsEnum.next();
            }
            boolean bl = scan = cell.getLevel() >= this.prefixGridScanLevel;
            if (!scan) {
                cells.addAll(0, cell.getSubCells(this.queryShape));
                continue;
            }
            BytesRef term = termsEnum.term();
            while (term != null && StringHelper.startsWith((BytesRef)term, (BytesRef)cellTerm)) {
                int termLevel = (scanCell = this.grid.getNode(term.bytes, term.offset, term.length, scanCell)).getLevel();
                if (termLevel <= this.detailLevel && (termLevel == this.detailLevel || scanCell.isLeaf())) {
                    Point cShape;
                    Object object = cShape = termLevel == this.grid.getMaxLevels() ? scanCell.getCenter() : scanCell.getShape();
                    if (this.queryShape.relate((Shape)cShape, this.grid.getSpatialContext()) != SpatialRelation.DISJOINT) {
                        docsEnum = termsEnum.docs(acceptDocs, docsEnum, false);
                        this.addDocs(docsEnum, bits);
                    }
                }
                term = termsEnum.next();
            }
        }
        return bits;
    }

    private void addDocs(DocsEnum docsEnum, OpenBitSet bits) throws IOException {
        int docid;
        while ((docid = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
            bits.fastSet(docid);
        }
    }

    public String toString() {
        return "GeoFilter{fieldName='" + this.fieldName + '\'' + ", shape=" + this.queryShape + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RecursivePrefixTreeFilter that = (RecursivePrefixTreeFilter)((Object)o);
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        if (this.prefixGridScanLevel != that.prefixGridScanLevel) {
            return false;
        }
        if (this.detailLevel != that.detailLevel) {
            return false;
        }
        return this.queryShape.equals(that.queryShape);
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.queryShape.hashCode();
        result = 31 * result + this.detailLevel;
        return result;
    }
}

