/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier.projections;

import org.apache.lucene.spatial.tier.projections.IProjector;

public class CartesianTierPlotter {
    public static final String DEFALT_FIELD_PREFIX = "_tier_";
    final int tierLevel;
    int tierLength;
    int tierBoxes;
    int tierVerticalPosDivider;
    final IProjector projector;
    final String fieldPrefix;
    Double idd = new Double(180.0);

    public CartesianTierPlotter(int tierLevel, IProjector projector, String fieldPrefix) {
        this.tierLevel = tierLevel;
        this.projector = projector;
        this.fieldPrefix = fieldPrefix;
        this.setTierLength();
        this.setTierBoxes();
        this.setTierVerticalPosDivider();
    }

    private void setTierLength() {
        this.tierLength = (int)Math.pow(2.0, this.tierLevel);
    }

    private void setTierBoxes() {
        this.tierBoxes = (int)Math.pow(this.tierLength, 2.0);
    }

    private void setTierVerticalPosDivider() {
        this.tierVerticalPosDivider = new Double(Math.ceil(Math.log10(new Integer(this.tierLength).doubleValue()))).intValue();
        this.tierVerticalPosDivider = (int)Math.pow(10.0, this.tierVerticalPosDivider);
    }

    public double getTierVerticalPosDivider() {
        return this.tierVerticalPosDivider;
    }

    public double getTierBoxId(double latitude, double longitude) {
        double[] coords = this.projector.coords(latitude, longitude);
        double id = this.getBoxId(coords[0]) + this.getBoxId(coords[1]) / (double)this.tierVerticalPosDivider;
        return id;
    }

    private double getBoxId(double coord) {
        return Math.floor(coord / (this.idd / (double)this.tierLength));
    }

    private double getBoxId(double coord, int tierLen) {
        return Math.floor(coord / (this.idd / (double)tierLen));
    }

    public String getTierFieldName() {
        return this.fieldPrefix + this.tierLevel;
    }

    public String getTierFieldName(int tierId) {
        return this.fieldPrefix + tierId;
    }

    public int bestFit(double miles) {
        int circ = 28892;
        double r = miles / 2.0;
        double corner = r - Math.sqrt(Math.pow(r, 2.0) / 2.0);
        double times = (double)circ / corner;
        int bestFit = (int)Math.ceil(this.log2(times)) + 1;
        if (bestFit > 15) {
            return 15;
        }
        return bestFit;
    }

    public double log2(double value) {
        return Math.log(value) / Math.log(2.0);
    }
}

