/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.serialized;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.util.DistanceToShapeValueSource;
import org.apache.lucene.spatial.util.ShapePredicateValueSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.BinaryCodec;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class SerializedDVStrategy
extends SpatialStrategy {
    private volatile int indexLastBufSize = 8192;

    public SerializedDVStrategy(SpatialContext ctx, String fieldName) {
        super(ctx, fieldName);
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        int bufSize = Math.max(128, (int)((double)this.indexLastBufSize * 1.5));
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(bufSize);
        final BytesRef bytesRef = new BytesRef();
        try {
            this.ctx.getBinaryCodec().writeShape((DataOutput)new DataOutputStream(byteStream), shape);
            byteStream.writeTo(new FilterOutputStream(null){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    bytesRef.bytes = b;
                    bytesRef.offset = off;
                    bytesRef.length = len;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.indexLastBufSize = bytesRef.length;
        return new Field[]{new BinaryDocValuesField(this.getFieldName(), bytesRef)};
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceToShapeValueSource(this.makeShapeValueSource(), queryPoint, multiplier, this.ctx);
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        ValueSource shapeValueSource = this.makeShapeValueSource();
        ShapePredicateValueSource predicateValueSource = new ShapePredicateValueSource(shapeValueSource, args.getOperation(), args.getShape());
        return new PredicateValueSourceQuery(predicateValueSource);
    }

    public ValueSource makeShapeValueSource() {
        return new ShapeDocValueSource(this.getFieldName(), this.ctx.getBinaryCodec());
    }

    static class ShapeDocValueSource
    extends ValueSource {
        private final String fieldName;
        private final BinaryCodec binaryCodec;

        private ShapeDocValueSource(String fieldName, BinaryCodec binaryCodec) {
            this.fieldName = fieldName;
            this.binaryCodec = binaryCodec;
        }

        public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
            final BinaryDocValues docValues = readerContext.reader().getBinaryDocValues(this.fieldName);
            return new FunctionValues(){
                int bytesRefDoc = -1;
                BytesRefBuilder bytesRef = new BytesRefBuilder();

                boolean fillBytes(int doc) {
                    if (this.bytesRefDoc != doc) {
                        this.bytesRef.copyBytes(docValues.get(doc));
                        this.bytesRefDoc = doc;
                    }
                    return this.bytesRef.length() != 0;
                }

                public boolean exists(int doc) {
                    return this.fillBytes(doc);
                }

                public boolean bytesVal(int doc, BytesRefBuilder target) {
                    target.clear();
                    if (this.fillBytes(doc)) {
                        target.copyBytes(this.bytesRef);
                        return true;
                    }
                    return false;
                }

                public Object objectVal(int docId) {
                    if (!this.fillBytes(docId)) {
                        return null;
                    }
                    DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(this.bytesRef.bytes(), 0, this.bytesRef.length()));
                    try {
                        return binaryCodec.readShape((DataInput)dataInput);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public Explanation explain(int doc) {
                    return Explanation.match((float)Float.NaN, (String)this.toString(doc), (Explanation[])new Explanation[0]);
                }

                public String toString(int doc) {
                    return this.description() + "=" + this.objectVal(doc);
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ShapeDocValueSource that = (ShapeDocValueSource)((Object)o);
            return this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            return result;
        }

        public String description() {
            return "shapeDocVal(" + this.fieldName + ")";
        }
    }

    static class PredicateValueSourceQuery
    extends Query {
        private final ValueSource predicateValueSource;

        public PredicateValueSourceQuery(ValueSource predicateValueSource) {
            this.predicateValueSource = predicateValueSource;
        }

        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new RandomAccessWeight(this){

                protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                    final FunctionValues predFuncValues = predicateValueSource.getValues(null, context);
                    return new Bits(){

                        public boolean get(int index) {
                            return predFuncValues.boolVal(index);
                        }

                        public int length() {
                            return context.reader().maxDoc();
                        }
                    };
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            PredicateValueSourceQuery that = (PredicateValueSourceQuery)((Object)o);
            return this.predicateValueSource.equals((Object)that.predicateValueSource);
        }

        public int hashCode() {
            return super.hashCode() + 31 * this.predicateValueSource.hashCode();
        }

        public String toString(String field) {
            return "PredicateValueSourceQuery(" + this.predicateValueSource.toString() + ")";
        }
    }
}

