/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.util.List;
import org.apache.lucene.analysis.cn.smart.Utility;
import org.apache.lucene.analysis.cn.smart.hhmm.BiSegGraph;
import org.apache.lucene.analysis.cn.smart.hhmm.SegGraph;
import org.apache.lucene.analysis.cn.smart.hhmm.SegToken;
import org.apache.lucene.analysis.cn.smart.hhmm.WordDictionary;

public class HHMMSegmenter {
    private static WordDictionary wordDict = WordDictionary.getInstance();

    private SegGraph createSegGraph(String sentence) {
        SegToken token;
        char[] charArray;
        int i = 0;
        int length = sentence.length();
        int[] charTypeArray = HHMMSegmenter.getCharTypes(sentence);
        StringBuffer wordBuf = new StringBuffer();
        int frequency = 0;
        SegGraph segGraph = new SegGraph();
        block9: while (i < length) {
            int j;
            boolean hasFullWidth = false;
            switch (charTypeArray[i]) {
                case 4: {
                    ++i;
                    continue block9;
                }
                case 3: {
                    wordBuf.delete(0, wordBuf.length());
                    wordBuf.append(sentence.charAt(i));
                    charArray = new char[]{sentence.charAt(i)};
                    frequency = wordDict.getFrequency(charArray);
                    token = new SegToken(charArray, i, j, 2, frequency);
                    segGraph.addToken(token);
                    int foundIndex = wordDict.getPrefixMatch(charArray);
                    for (j = i + 1; j <= length && foundIndex != -1; ++j) {
                        if (wordDict.isEqual(charArray, foundIndex) && charArray.length > 1) {
                            frequency = wordDict.getFrequency(charArray);
                            token = new SegToken(charArray, i, j, 2, frequency);
                            segGraph.addToken(token);
                        }
                        while (j < length && charTypeArray[j] == 4) {
                            ++j;
                        }
                        if (j >= length || charTypeArray[j] != 3) break;
                        wordBuf.append(sentence.charAt(j));
                        charArray = new char[wordBuf.length()];
                        wordBuf.getChars(0, charArray.length, charArray, 0);
                        foundIndex = wordDict.getPrefixMatch(charArray, foundIndex);
                    }
                    ++i;
                    continue block9;
                }
                case 5: {
                    hasFullWidth = true;
                }
                case 1: {
                    for (j = i + 1; j < length && (charTypeArray[j] == 1 || charTypeArray[j] == 5); ++j) {
                        if (charTypeArray[j] != 5) continue;
                        hasFullWidth = true;
                    }
                    charArray = Utility.STRING_CHAR_ARRAY;
                    frequency = wordDict.getFrequency(charArray);
                    int wordType = hasFullWidth ? 6 : 3;
                    token = new SegToken(charArray, i, j, wordType, frequency);
                    segGraph.addToken(token);
                    i = j;
                    continue block9;
                }
                case 6: {
                    hasFullWidth = true;
                }
                case 2: {
                    for (j = i + 1; j < length && (charTypeArray[j] == 2 || charTypeArray[j] == 6); ++j) {
                        if (charTypeArray[j] != 6) continue;
                        hasFullWidth = true;
                    }
                    charArray = Utility.NUMBER_CHAR_ARRAY;
                    frequency = wordDict.getFrequency(charArray);
                    int wordType = hasFullWidth ? 7 : 4;
                    token = new SegToken(charArray, i, j, wordType, frequency);
                    segGraph.addToken(token);
                    i = j;
                    continue block9;
                }
                case 0: {
                    j = i + 1;
                    frequency = 2159997;
                    charArray = new char[]{sentence.charAt(i)};
                    token = new SegToken(charArray, i, j, 5, frequency);
                    segGraph.addToken(token);
                    i = j;
                    continue block9;
                }
            }
            j = i + 1;
            charArray = Utility.STRING_CHAR_ARRAY;
            frequency = wordDict.getFrequency(charArray);
            token = new SegToken(charArray, i, j, 3, frequency);
            segGraph.addToken(token);
            i = j;
        }
        charArray = Utility.START_CHAR_ARRAY;
        frequency = wordDict.getFrequency(charArray);
        token = new SegToken(charArray, -1, 0, 0, frequency);
        segGraph.addToken(token);
        charArray = Utility.END_CHAR_ARRAY;
        frequency = wordDict.getFrequency(charArray);
        token = new SegToken(charArray, length, length + 1, 1, frequency);
        segGraph.addToken(token);
        return segGraph;
    }

    private static int[] getCharTypes(String sentence) {
        int length = sentence.length();
        int[] charTypeArray = new int[length];
        for (int i = 0; i < length; ++i) {
            charTypeArray[i] = Utility.getCharType(sentence.charAt(i));
        }
        return charTypeArray;
    }

    public List process(String sentence) {
        SegGraph segGraph = this.createSegGraph(sentence);
        BiSegGraph biSegGraph = new BiSegGraph(segGraph);
        List shortPath = biSegGraph.getShortPath();
        return shortPath;
    }
}

