/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.replicator.Replicator;
import org.apache.lucene.replicator.Revision;
import org.apache.lucene.replicator.SessionExpiredException;
import org.apache.lucene.replicator.SessionToken;
import org.apache.lucene.store.AlreadyClosedException;

public class LocalReplicator
implements Replicator {
    public static final long DEFAULT_SESSION_EXPIRATION_THRESHOLD = 1800000L;
    private long expirationThresholdMilllis = 1800000L;
    private volatile RefCountedRevision currentRevision;
    private volatile boolean closed = false;
    private final AtomicInteger sessionToken = new AtomicInteger(0);
    private final Map<String, ReplicationSession> sessions = new HashMap<String, ReplicationSession>();

    private void checkExpiredSessions() throws IOException {
        ArrayList<ReplicationSession> toExpire = new ArrayList<ReplicationSession>();
        for (ReplicationSession token : this.sessions.values()) {
            if (!token.isExpired(this.expirationThresholdMilllis)) continue;
            toExpire.add(token);
        }
        for (ReplicationSession token : toExpire) {
            this.releaseSession(token.session.id);
        }
    }

    private void releaseSession(String sessionID) throws IOException {
        ReplicationSession session = this.sessions.remove(sessionID);
        if (session != null) {
            session.revision.decRef();
        }
    }

    protected final synchronized void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("This replicator has already been closed");
        }
    }

    @Override
    public synchronized SessionToken checkForUpdate(String currentVersion) {
        this.ensureOpen();
        if (this.currentRevision == null) {
            return null;
        }
        if (currentVersion != null && this.currentRevision.revision.compareTo(currentVersion) <= 0) {
            return null;
        }
        this.currentRevision.incRef();
        String sessionID = Integer.toString(this.sessionToken.incrementAndGet());
        SessionToken sessionToken = new SessionToken(sessionID, this.currentRevision.revision);
        ReplicationSession timedSessionToken = new ReplicationSession(sessionToken, this.currentRevision);
        this.sessions.put(sessionID, timedSessionToken);
        return sessionToken;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            for (ReplicationSession session : this.sessions.values()) {
                session.revision.decRef();
            }
            this.sessions.clear();
            this.closed = true;
        }
    }

    public long getExpirationThreshold() {
        return this.expirationThresholdMilllis;
    }

    @Override
    public synchronized InputStream obtainFile(String sessionID, String source, String fileName) throws IOException {
        this.ensureOpen();
        ReplicationSession session = this.sessions.get(sessionID);
        if (session != null && session.isExpired(this.expirationThresholdMilllis)) {
            this.releaseSession(sessionID);
            session = null;
        }
        if (session == null) {
            throw new SessionExpiredException("session (" + sessionID + ") expired while obtaining file: source=" + source + " file=" + fileName);
        }
        this.sessions.get(sessionID).markAccessed();
        return session.revision.revision.open(source, fileName);
    }

    @Override
    public synchronized void publish(Revision revision) throws IOException {
        this.ensureOpen();
        if (this.currentRevision != null) {
            int compare = revision.compareTo(this.currentRevision.revision);
            if (compare == 0) {
                revision.release();
                return;
            }
            if (compare < 0) {
                revision.release();
                throw new IllegalArgumentException("Cannot publish an older revision: rev=" + revision + " current=" + this.currentRevision);
            }
        }
        RefCountedRevision oldRevision = this.currentRevision;
        this.currentRevision = new RefCountedRevision(revision);
        if (oldRevision != null) {
            oldRevision.decRef();
        }
        this.checkExpiredSessions();
    }

    @Override
    public synchronized void release(String sessionID) throws IOException {
        this.ensureOpen();
        this.releaseSession(sessionID);
    }

    public synchronized void setExpirationThreshold(long expirationThreshold) throws IOException {
        this.ensureOpen();
        this.expirationThresholdMilllis = expirationThreshold;
        this.checkExpiredSessions();
    }

    private static class ReplicationSession {
        public final SessionToken session;
        public final RefCountedRevision revision;
        private volatile long lastAccessTime;

        ReplicationSession(SessionToken session, RefCountedRevision revision) {
            this.session = session;
            this.revision = revision;
            this.lastAccessTime = System.currentTimeMillis();
        }

        boolean isExpired(long expirationThreshold) {
            return this.lastAccessTime < System.currentTimeMillis() - expirationThreshold;
        }

        void markAccessed() {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    private static class RefCountedRevision {
        private final AtomicInteger refCount = new AtomicInteger(1);
        public final Revision revision;

        public RefCountedRevision(Revision revision) {
            this.revision = revision;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decRef() throws IOException {
            if (this.refCount.get() <= 0) {
                throw new IllegalStateException("this revision is already released");
            }
            int rc = this.refCount.decrementAndGet();
            if (rc == 0) {
                boolean success = false;
                try {
                    this.revision.release();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.refCount.incrementAndGet();
                    }
                }
            } else if (rc < 0) {
                throw new IllegalStateException("too many decRef calls: refCount is " + rc + " after decrement");
            }
        }

        public void incRef() {
            this.refCount.incrementAndGet();
        }
    }
}

