/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.replicator.nrt.CopyOneFile;
import org.apache.lucene.replicator.nrt.CopyState;
import org.apache.lucene.replicator.nrt.FileMetaData;
import org.apache.lucene.replicator.nrt.Node;
import org.apache.lucene.replicator.nrt.ReplicaNode;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

public abstract class CopyJob
implements Comparable<CopyJob> {
    private static final AtomicLong counter = new AtomicLong();
    protected final ReplicaNode dest;
    protected final Map<String, FileMetaData> files;
    public final long ord = counter.incrementAndGet();
    public final boolean highPriority;
    public final OnceDone onceDone;
    public final long startNS = System.nanoTime();
    public final String reason;
    protected final List<Map.Entry<String, FileMetaData>> toCopy;
    protected long totBytes;
    protected long totBytesCopied;
    protected CopyOneFile current;
    protected volatile Throwable exc;
    protected volatile String cancelReason;
    protected final Map<String, String> copiedFiles = new ConcurrentHashMap<String, String>();

    protected CopyJob(String reason, Map<String, FileMetaData> files, ReplicaNode dest, boolean highPriority, OnceDone onceDone) throws IOException {
        this.reason = reason;
        this.files = files;
        this.dest = dest;
        this.highPriority = highPriority;
        this.onceDone = onceDone;
        try {
            this.toCopy = dest.getFilesToCopy(this.files);
        }
        catch (Throwable t) {
            this.cancel("exc during init", t);
            throw new CorruptIndexException("exception while checking local files", "n/a", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void transferAndCancel(CopyJob prevJob) throws IOException {
        CopyJob copyJob = prevJob;
        synchronized (copyJob) {
            this.dest.message("CopyJob: now transfer prevJob " + String.valueOf(prevJob));
            try {
                this._transferAndCancel(prevJob);
            }
            catch (Throwable t) {
                this.dest.message("xfer: exc during transferAndCancel");
                this.cancel("exc during transferAndCancel", t);
                throw IOUtils.rethrowAlways((Throwable)t);
            }
        }
    }

    private synchronized void _transferAndCancel(CopyJob prevJob) throws IOException {
        assert (Thread.holdsLock(prevJob));
        if (prevJob.exc != null) {
            this.dest.message("xfer: prevJob was already cancelled; skip transfer");
            return;
        }
        prevJob.exc = new Throwable();
        Iterator<Map.Entry<String, FileMetaData>> it = this.toCopy.iterator();
        long bytesAlreadyCopied = 0L;
        while (it.hasNext()) {
            Map.Entry<String, FileMetaData> ent = it.next();
            String fileName = ent.getKey();
            String prevTmpFileName = prevJob.copiedFiles.get(fileName);
            if (prevTmpFileName != null) {
                long fileLength = ent.getValue().length();
                bytesAlreadyCopied += fileLength;
                this.dest.message("xfer: carry over already-copied file " + fileName + " (" + prevTmpFileName + ", " + fileLength + " bytes)");
                this.copiedFiles.put(fileName, prevTmpFileName);
                prevJob.copiedFiles.remove(fileName);
                it.remove();
                continue;
            }
            if (prevJob.current != null && prevJob.current.name.equals(fileName)) {
                this.dest.message("xfer: carry over in-progress file " + fileName + " (" + prevJob.current.tmpName + ") bytesCopied=" + prevJob.current.getBytesCopied() + " of " + prevJob.current.bytesToCopy);
                bytesAlreadyCopied += prevJob.current.getBytesCopied();
                assert (this.current == null);
                this.current = this.newCopyOneFile(prevJob.current);
                assert (prevJob.current.getBytesCopied() <= prevJob.current.bytesToCopy);
                prevJob.current = null;
                this.totBytes += this.current.metaData.length();
                it.remove();
                continue;
            }
            this.dest.message("xfer: file " + fileName + " will be fully copied");
        }
        this.dest.message("xfer: " + bytesAlreadyCopied + " bytes already copied of " + this.totBytes);
        this.dest.message("xfer: now delete old temp files: " + String.valueOf(prevJob.copiedFiles.values()));
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.dest.dir, prevJob.copiedFiles.values());
        if (prevJob.current != null) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{prevJob.current});
            if (Node.VERBOSE_FILES) {
                this.dest.message("remove partial file " + prevJob.current.tmpName);
            }
            this.dest.deleter.forceDeleteFile(prevJob.current.tmpName);
            prevJob.current = null;
        }
    }

    protected abstract CopyOneFile newCopyOneFile(CopyOneFile var1);

    public abstract void start() throws IOException;

    public abstract void runBlocking() throws Exception;

    public void cancel(String reason, Throwable exc) throws IOException {
        if (this.exc != null) {
            return;
        }
        this.dest.message(String.format(Locale.ROOT, "top: cancel after copying %s; exc=%s:\n  files=%s\n  copiedFiles=%s", Node.bytesToString(this.totBytesCopied), exc, this.files == null ? "null" : this.files.keySet(), this.copiedFiles.keySet()));
        if (exc == null) {
            exc = new Throwable();
        }
        this.exc = exc;
        this.cancelReason = reason;
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.dest.dir, this.copiedFiles.values());
        if (this.current != null) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.current});
            if (Node.VERBOSE_FILES) {
                this.dest.message("remove partial file " + this.current.tmpName);
            }
            this.dest.deleter.forceDeleteFile(this.current.tmpName);
            this.current = null;
        }
    }

    public abstract boolean conflicts(CopyJob var1);

    public abstract void finish() throws IOException;

    public abstract boolean getFailed();

    public abstract Set<String> getFileNamesToCopy();

    public abstract Set<String> getFileNames();

    public abstract CopyState getCopyState();

    public abstract long getTotalBytesCopied();

    public static interface OnceDone {
        public void run(CopyJob var1) throws IOException;
    }
}

