/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.processors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.GroupQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.NoTokenFoundQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QuotedFieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.RangeQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.TokenizedPhraseQueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.standard.nodes.MultiPhraseQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.PrefixWildcardQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.StandardBooleanQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.WildcardQueryNode;

public class AnalyzerQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private Analyzer analyzer;
    private boolean positionIncrementsEnabled;
    private final Pattern wildcardPattern = Pattern.compile("(\\.)|([?*]+)");

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        Analyzer analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
        if (analyzer != null) {
            this.analyzer = analyzer;
            this.positionIncrementsEnabled = false;
            Boolean positionIncrementsEnabled = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ENABLE_POSITION_INCREMENTS);
            if (positionIncrementsEnabled != null) {
                this.positionIncrementsEnabled = positionIncrementsEnabled;
            }
            if (this.analyzer != null) {
                return super.process(queryTree);
            }
        }
        return queryTree;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        if (node.getParent() instanceof RangeQueryNode) {
            return node;
        }
        if (node instanceof PrefixWildcardQueryNode) {
            PrefixWildcardQueryNode prefixNode = (PrefixWildcardQueryNode)node;
            return this.postProcessPrefixWildcardQueryNode(prefixNode);
        }
        if (node instanceof WildcardQueryNode) {
            WildcardQueryNode wildcardNode = (WildcardQueryNode)node;
            return this.postProcessWildcardQueryNode(wildcardNode);
        }
        if (node instanceof FuzzyQueryNode) {
            FuzzyQueryNode fuzzyNode = (FuzzyQueryNode)node;
            return this.postProcessFuzzyQueryNode(fuzzyNode);
        }
        if (node instanceof FieldQueryNode) {
            FieldQueryNode fieldNode = (FieldQueryNode)node;
            return this.postProcessFieldQueryNode(fieldNode);
        }
        return node;
    }

    private QueryNode postProcessPrefixWildcardQueryNode(PrefixWildcardQueryNode prefixNode) throws QueryNodeException {
        String field = prefixNode.getFieldAsString();
        String termStr = prefixNode.getTextAsString();
        if (termStr == null) {
            throw new QueryNodeException(new IllegalArgumentException("PrefixWildcardQueryNode term is null."));
        }
        int termLen = termStr.length();
        if (termLen < 1) {
            throw new QueryNodeException(new IllegalArgumentException("PrefixWildcardQueryNode term is empty"));
        }
        String wildCard = termStr.substring(termLen - 1);
        String normalized = this.normalizeSingleChunk(field, termStr, termStr.substring(0, termLen - 1));
        return new PrefixWildcardQueryNode(field, normalized == null ? termStr : normalized + wildCard, prefixNode.getBegin(), prefixNode.getEnd());
    }

    private QueryNode postProcessWildcardQueryNode(WildcardQueryNode wildcardNode) throws QueryNodeException {
        String field = wildcardNode.getFieldAsString();
        String termStr = wildcardNode.getTextAsString();
        Matcher wildcardMatcher = this.wildcardPattern.matcher(termStr);
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (wildcardMatcher.find()) {
            if (wildcardMatcher.group(1) != null) continue;
            if (wildcardMatcher.start() > 0) {
                String chunk = termStr.substring(last, wildcardMatcher.start());
                String normalized = this.normalizeSingleChunk(field, termStr, chunk);
                if (normalized == null) {
                    return wildcardNode;
                }
                sb.append(normalized);
            }
            sb.append(wildcardMatcher.group(2));
            last = wildcardMatcher.end();
        }
        if (last < termStr.length()) {
            String normalized = this.normalizeSingleChunk(field, termStr, termStr.substring(last));
            if (normalized == null) {
                return wildcardNode;
            }
            sb.append(normalized);
        }
        return new WildcardQueryNode(field, sb.toString(), wildcardNode.getBegin(), wildcardNode.getEnd());
    }

    private QueryNode postProcessFuzzyQueryNode(FuzzyQueryNode fuzzyNode) throws QueryNodeException {
        String termStr;
        String field;
        String normalized = this.normalizeSingleChunk(field = fuzzyNode.getFieldAsString(), termStr = fuzzyNode.getTextAsString(), termStr);
        return new FuzzyQueryNode(field, normalized == null ? termStr : normalized, fuzzyNode.getSimilarity(), fuzzyNode.getBegin(), fuzzyNode.getEnd());
    }

    protected String normalizeSingleChunk(String field, String termStr, String chunk) throws QueryNodeException {
        String normalized;
        block18: {
            normalized = null;
            TokenStream stream = null;
            try {
                stream = this.analyzer.normalizedTokenStream(field, chunk);
                stream.reset();
                CharTermAttribute termAtt = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
                if (stream.incrementToken()) {
                    normalized = termAtt.toString();
                    Boolean multipleOutputs = false;
                    while (stream.incrementToken()) {
                        multipleOutputs = true;
                    }
                    if (multipleOutputs.booleanValue()) {
                        String string = null;
                        return string;
                    }
                    break block18;
                }
                String string = null;
                return string;
            }
            catch (IOException e) {
                throw new QueryNodeException(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.end();
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return normalized;
    }

    private QueryNode postProcessFieldQueryNode(FieldQueryNode fieldNode) throws QueryNodeException {
        TokenStream source;
        String text = fieldNode.getTextAsString();
        String field = fieldNode.getFieldAsString();
        try {
            source = this.analyzer.tokenStream(field, text);
            source.reset();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        CachingTokenFilter buffer = new CachingTokenFilter(source);
        PositionIncrementAttribute posIncrAtt = null;
        int numTokens = 0;
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
            posIncrAtt = (PositionIncrementAttribute)buffer.getAttribute(PositionIncrementAttribute.class);
        }
        try {
            while (buffer.incrementToken()) {
                int positionIncrement;
                ++numTokens;
                int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                if (positionIncrement != 0) {
                    positionCount += positionIncrement;
                    continue;
                }
                severalTokensAtSamePosition = true;
            }
        }
        catch (IOException positionIncrement) {
            // empty catch block
        }
        try {
            buffer.reset();
            source.close();
        }
        catch (IOException positionIncrement) {
            // empty catch block
        }
        if (!buffer.hasAttribute(CharTermAttribute.class)) {
            return new NoTokenFoundQueryNode();
        }
        CharTermAttribute termAtt = (CharTermAttribute)buffer.getAttribute(CharTermAttribute.class);
        if (numTokens == 0) {
            return new NoTokenFoundQueryNode();
        }
        if (numTokens == 1) {
            String term = null;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
            }
            catch (IOException hasNext) {
                // empty catch block
            }
            fieldNode.setText(term);
            return fieldNode;
        }
        if (severalTokensAtSamePosition || !(fieldNode instanceof QuotedFieldQueryNode)) {
            if (positionCount == 1 || !(fieldNode instanceof QuotedFieldQueryNode)) {
                LinkedList<QueryNode> children = new LinkedList<QueryNode>();
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                    }
                    catch (IOException hasNext) {
                        // empty catch block
                    }
                    children.add(new FieldQueryNode(field, term, -1, -1));
                }
                return new GroupQueryNode(new StandardBooleanQueryNode(children, positionCount == 1));
            }
            MultiPhraseQueryNode mpq = new MultiPhraseQueryNode();
            ArrayList<FieldQueryNode> multiTerms = new ArrayList<FieldQueryNode>();
            int position = -1;
            int termGroupCount = 0;
            for (int i = 0; i < numTokens; ++i) {
                Object term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    for (FieldQueryNode termNode : multiTerms) {
                        if (this.positionIncrementsEnabled) {
                            termNode.setPositionIncrement(position);
                        } else {
                            termNode.setPositionIncrement(termGroupCount);
                        }
                        mpq.add(termNode);
                    }
                    ++termGroupCount;
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(new FieldQueryNode(field, (CharSequence)term, -1, -1));
            }
            for (FieldQueryNode termNode : multiTerms) {
                if (this.positionIncrementsEnabled) {
                    termNode.setPositionIncrement(position);
                } else {
                    termNode.setPositionIncrement(termGroupCount);
                }
                mpq.add(termNode);
            }
            return mpq;
        }
        TokenizedPhraseQueryNode pq = new TokenizedPhraseQueryNode();
        int position = -1;
        for (int i = 0; i < numTokens; ++i) {
            String term = null;
            int positionIncrement = 1;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
                if (posIncrAtt != null) {
                    positionIncrement = posIncrAtt.getPositionIncrement();
                }
            }
            catch (IOException hasNext) {
                // empty catch block
            }
            FieldQueryNode newFieldNode = new FieldQueryNode(field, term, -1, -1);
            if (this.positionIncrementsEnabled) {
                newFieldNode.setPositionIncrement(position += positionIncrement);
            } else {
                newFieldNode.setPositionIncrement(i);
            }
            pq.add(newFieldNode);
        }
        return pq;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

