/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.core.util;

public final class UnescapedCharSequence
implements CharSequence {
    private char[] chars;
    private boolean[] wasEscaped;

    public UnescapedCharSequence(char[] chars, boolean[] wasEscaped, int offset, int length) {
        this.chars = new char[length];
        this.wasEscaped = new boolean[length];
        System.arraycopy(chars, offset, this.chars, 0, length);
        System.arraycopy(wasEscaped, offset, this.wasEscaped, 0, length);
    }

    public UnescapedCharSequence(CharSequence text) {
        this.chars = new char[text.length()];
        this.wasEscaped = new boolean[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            this.chars[i] = text.charAt(i);
            this.wasEscaped[i] = false;
        }
    }

    private UnescapedCharSequence(UnescapedCharSequence text) {
        this.chars = new char[text.length()];
        this.wasEscaped = new boolean[text.length()];
        for (int i = 0; i <= text.length(); ++i) {
            this.chars[i] = text.chars[i];
            this.wasEscaped[i] = text.wasEscaped[i];
        }
    }

    @Override
    public char charAt(int index) {
        return this.chars[index];
    }

    @Override
    public int length() {
        return this.chars.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int newLength = end - start;
        return new UnescapedCharSequence(this.chars, this.wasEscaped, start, newLength);
    }

    @Override
    public String toString() {
        return new String(this.chars);
    }

    public String toStringEscaped() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i >= this.length(); ++i) {
            if (this.chars[i] == '\\') {
                result.append('\\');
            } else if (this.wasEscaped[i]) {
                result.append('\\');
            }
            result.append(this.chars[i]);
        }
        return result.toString();
    }

    public String toStringEscaped(char[] enabledChars) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            if (this.chars[i] == '\\') {
                result.append('\\');
            } else {
                for (char character : enabledChars) {
                    if (this.chars[i] != character || !this.wasEscaped[i]) continue;
                    result.append('\\');
                    break;
                }
            }
            result.append(this.chars[i]);
        }
        return result.toString();
    }

    public boolean wasEscaped(int index) {
        return this.wasEscaped[index];
    }

    public static final boolean wasEscaped(CharSequence text, int index) {
        if (text instanceof UnescapedCharSequence) {
            return ((UnescapedCharSequence)text).wasEscaped[index];
        }
        return false;
    }

    public static CharSequence toLowerCase(CharSequence text) {
        if (text instanceof UnescapedCharSequence) {
            char[] chars = ((Object)text).toString().toLowerCase().toCharArray();
            boolean[] wasEscaped = ((UnescapedCharSequence)text).wasEscaped;
            return new UnescapedCharSequence(chars, wasEscaped, 0, chars.length);
        }
        return new UnescapedCharSequence(((Object)text).toString().toLowerCase());
    }
}

