/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.ext;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.ext.ExtensionQuery;
import org.apache.lucene.queryParser.ext.Extensions;
import org.apache.lucene.queryParser.ext.ParserExtension;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;

public class ExtendableQueryParser
extends QueryParser {
    private final String defaultField;
    private final Extensions extensions;
    private static final Extensions DEFAULT_EXTENSION = new Extensions();

    public ExtendableQueryParser(Version matchVersion, String f, Analyzer a) {
        this(matchVersion, f, a, DEFAULT_EXTENSION);
    }

    public ExtendableQueryParser(Version matchVersion, String f, Analyzer a, Extensions ext) {
        super(matchVersion, f, a);
        this.defaultField = f;
        this.extensions = ext;
    }

    public char getExtensionFieldDelimiter() {
        return this.extensions.getExtensionFieldDelimiter();
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        Extensions.Pair<String, String> splitExtensionField = this.extensions.splitExtensionField(this.defaultField, field);
        ParserExtension extension = this.extensions.getExtension((String)splitExtensionField.cud);
        if (extension != null) {
            return extension.parse(new ExtensionQuery(this, (String)splitExtensionField.cur, queryText));
        }
        return super.getFieldQuery(field, queryText, quoted);
    }
}

