/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import org.apache.lucene.messages.Message;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeError;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.FieldableNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

public class SlopQueryNode
extends QueryNodeImpl
implements FieldableNode {
    private static final long serialVersionUID = 0L;
    private int value = 0;

    public SlopQueryNode(QueryNode query, int value) {
        if (query == null) {
            throw new QueryNodeError((Message)new MessageImpl(QueryParserMessages.NODE_ACTION_NOT_SUPPORTED, new Object[]{"query", "null"}));
        }
        this.value = value;
        this.setLeaf(false);
        this.allocate();
        this.add(query);
    }

    public QueryNode getChild() {
        return this.getChildren().get(0);
    }

    public int getValue() {
        return this.value;
    }

    private CharSequence getValueString() {
        Float f = Float.valueOf(this.value);
        if (f.floatValue() == (float)f.longValue()) {
            return "" + f.longValue();
        }
        return "" + f;
    }

    public String toString() {
        return "<slop value='" + this.getValueString() + "'>" + "\n" + ((Object)this.getChild()).toString() + "\n</slop>";
    }

    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        if (this.getChild() == null) {
            return "";
        }
        return this.getChild().toQueryString(escapeSyntaxParser) + "~" + this.getValueString();
    }

    public QueryNode cloneTree() throws CloneNotSupportedException {
        SlopQueryNode clone = (SlopQueryNode)super.cloneTree();
        clone.value = this.value;
        return clone;
    }

    public CharSequence getField() {
        QueryNode child = this.getChild();
        if (child instanceof FieldableNode) {
            return ((FieldableNode)child).getField();
        }
        return null;
    }

    public void setField(CharSequence fieldName) {
        QueryNode child = this.getChild();
        if (child instanceof FieldableNode) {
            ((FieldableNode)child).setField(fieldName);
        }
    }
}

