/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public class DuplicateFilter
extends Filter {
    String fieldName;
    int keepMode = 1;
    public static final int KM_USE_FIRST_OCCURRENCE = 1;
    public static final int KM_USE_LAST_OCCURRENCE = 2;
    int processingMode = 1;
    public static final int PM_FULL_VALIDATION = 1;
    public static final int PM_FAST_INVALIDATION = 2;

    public DuplicateFilter(String fieldName) {
        this(fieldName, 2, 1);
    }

    public DuplicateFilter(String fieldName, int keepMode, int processingMode) {
        this.fieldName = fieldName;
        this.keepMode = keepMode;
        this.processingMode = processingMode;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.processingMode == 2) {
            return this.fastBits(reader);
        }
        return this.correctBits(reader);
    }

    private OpenBitSet correctBits(IndexReader reader) throws IOException {
        OpenBitSet bits = new OpenBitSet((long)reader.maxDoc());
        Term startTerm = new Term(this.fieldName);
        TermEnum te = reader.terms(startTerm);
        if (te != null) {
            Term currTerm = te.term();
            while (currTerm != null && currTerm.field() == startTerm.field()) {
                int lastDoc = -1;
                TermDocs td = reader.termDocs(currTerm);
                if (td.next()) {
                    if (this.keepMode == 1) {
                        bits.set((long)td.doc());
                    } else {
                        do {
                            lastDoc = td.doc();
                        } while (td.next());
                        bits.set((long)lastDoc);
                    }
                }
                if (!te.next()) break;
                currTerm = te.term();
            }
        }
        return bits;
    }

    private OpenBitSet fastBits(IndexReader reader) throws IOException {
        OpenBitSet bits = new OpenBitSet((long)reader.maxDoc());
        bits.set(0L, (long)reader.maxDoc());
        Term startTerm = new Term(this.fieldName);
        TermEnum te = reader.terms(startTerm);
        if (te != null) {
            Term currTerm = te.term();
            while (currTerm != null && currTerm.field() == startTerm.field()) {
                if (te.docFreq() > 1) {
                    int lastDoc = -1;
                    TermDocs td = reader.termDocs(currTerm);
                    td.next();
                    if (this.keepMode == 1) {
                        td.next();
                    }
                    do {
                        lastDoc = td.doc();
                        bits.clear((long)lastDoc);
                    } while (td.next());
                    if (this.keepMode == 2) {
                        bits.set((long)lastDoc);
                    }
                }
                if (!te.next()) break;
                currTerm = te.term();
            }
        }
        return bits;
    }

    public static void main(String[] args) throws Exception {
        IndexReader r = IndexReader.open((String)"/indexes/personCentricAnon");
        long start = System.currentTimeMillis();
        DuplicateFilter df = new DuplicateFilter("vehicle.vrm", 2, 2);
        BitSet b = df.bits(r);
        long end = System.currentTimeMillis() - start;
        System.out.println(b.cardinality() + " in " + end + " ms ");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public int getKeepMode() {
        return this.keepMode;
    }

    public void setKeepMode(int keepMode) {
        this.keepMode = keepMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        DuplicateFilter other = (DuplicateFilter)((Object)obj);
        return this.keepMode == other.keepMode && this.processingMode == other.processingMode && (this.fieldName == other.fieldName || this.fieldName != null && this.fieldName.equals(other.fieldName));
    }

    public int hashCode() {
        int hash = 217;
        hash = 31 * hash + this.keepMode;
        hash = 31 * hash + this.processingMode;
        hash = 31 * hash + this.fieldName.hashCode();
        return hash;
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public void setProcessingMode(int processingMode) {
        this.processingMode = processingMode;
    }
}

