/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.pruning;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.pruning.PruningPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TermPruningPolicy
extends PruningPolicy {
    protected Map<String, Integer> fieldFlags;
    protected IndexReader in;

    protected TermPruningPolicy(IndexReader in, Map<String, Integer> fieldFlags) {
        this.in = in;
        this.fieldFlags = fieldFlags != null ? fieldFlags : Collections.emptyMap();
    }

    public boolean pruneWholeTermVector(int docNumber, String field) throws IOException {
        return this.fieldFlags.containsKey(field) && (this.fieldFlags.get(field) & 4) != 0;
    }

    public boolean pruneAllFieldPostings(String field) throws IOException {
        return this.fieldFlags.containsKey(field) && (this.fieldFlags.get(field) & 1) != 0;
    }

    public abstract void initPositionsTerm(TermPositions var1, Term var2) throws IOException;

    public boolean prunePayload(TermPositions in, Term curTerm) {
        return this.fieldFlags.containsKey(curTerm.field()) && (this.fieldFlags.get(curTerm.field()) & 8) != 0;
    }

    public abstract int pruneTermVectorTerms(int var1, String var2, String[] var3, int[] var4, TermFreqVector var5) throws IOException;

    public abstract boolean pruneTermEnum(TermEnum var1) throws IOException;

    public abstract boolean pruneAllPositions(TermPositions var1, Term var2) throws IOException;

    public abstract int pruneSomePositions(int var1, int[] var2, Term var3);
}

