/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.pruning;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.pruning.TermPruningPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFTermPruningPolicy
extends TermPruningPolicy {
    protected Map<String, Integer> thresholds;
    protected int defThreshold;
    protected int curThr;

    public TFTermPruningPolicy(IndexReader in, Map<String, Integer> fieldFlags, Map<String, Integer> thresholds, int defThreshold) {
        super(in, fieldFlags);
        this.defThreshold = defThreshold;
        this.thresholds = thresholds != null ? thresholds : Collections.emptyMap();
    }

    @Override
    public boolean pruneTermEnum(TermEnum te) throws IOException {
        int thr = this.defThreshold;
        String termKey = te.term().field() + ":" + te.term().text();
        if (this.thresholds.containsKey(termKey)) {
            thr = this.thresholds.get(termKey);
        } else if (this.thresholds.containsKey(te.term().field())) {
            thr = this.thresholds.get(te.term().field());
        }
        TermDocs td = this.in.termDocs(te.term());
        boolean pass = false;
        do {
            if (td.freq() < thr) continue;
            pass = true;
            break;
        } while (td.next());
        td.close();
        return !pass;
    }

    @Override
    public void initPositionsTerm(TermPositions in, Term t) throws IOException {
        this.curThr = this.defThreshold;
        String termKey = t.field() + ":" + t.text();
        if (this.thresholds.containsKey(termKey)) {
            this.curThr = this.thresholds.get(termKey);
        } else if (this.thresholds.containsKey(t.field())) {
            this.curThr = this.thresholds.get(t.field());
        }
    }

    @Override
    public boolean pruneAllPositions(TermPositions termPositions, Term t) throws IOException {
        return termPositions.freq() < this.curThr;
    }

    @Override
    public int pruneTermVectorTerms(int docNumber, String field, String[] terms, int[] freqs, TermFreqVector tfv) throws IOException {
        int thr = this.defThreshold;
        if (this.thresholds.containsKey(field)) {
            thr = this.thresholds.get(field);
        }
        int removed = 0;
        for (int i = 0; i < terms.length; ++i) {
            int termThr = thr;
            String t = field + ":" + terms[i];
            if (this.thresholds.containsKey(t)) {
                termThr = this.thresholds.get(t);
            }
            if (freqs[i] >= termThr) continue;
            terms[i] = null;
            ++removed;
        }
        return removed;
    }

    @Override
    public int pruneSomePositions(int docNum, int[] positions, Term curTerm) {
        return 0;
    }
}

