/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.pruning;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.pruning.PruningPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorePruningPolicy
extends PruningPolicy {
    private static final Logger LOG = Logger.getLogger(StorePruningPolicy.class.getName());
    protected Map<String, Integer> fieldFlags;
    protected Set<String> deleteAll;
    protected DelFieldSelector fs;
    protected IndexReader in;
    protected int delFields;

    public StorePruningPolicy(IndexReader in, Map<String, Integer> fieldFlags) {
        if (fieldFlags != null) {
            this.fieldFlags = fieldFlags;
            this.deleteAll = new HashSet<String>();
            for (Map.Entry<String, Integer> e : fieldFlags.entrySet()) {
                if (e.getValue() != 255) continue;
                this.deleteAll.add(e.getKey());
            }
        } else {
            this.fieldFlags = Collections.emptyMap();
            this.deleteAll = Collections.emptySet();
        }
        this.fs = new DelFieldSelector(fieldFlags);
        this.in = in;
    }

    public FieldInfos getFieldInfos(FieldInfos allInfos) {
        FieldInfos res = new FieldInfos();
        for (FieldInfo fi : allInfos) {
            if (this.deleteAll.contains(fi.name)) continue;
            res.add(fi);
        }
        return res;
    }

    public Document pruneDocument(int doc, FieldSelector parent) throws IOException {
        if (this.fieldFlags.isEmpty()) {
            return this.in.document(doc, parent);
        }
        this.fs.setParent(parent);
        return this.in.document(doc, (FieldSelector)this.fs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DelFieldSelector
    implements FieldSelector {
        private static final long serialVersionUID = -4913592063491685103L;
        private FieldSelector parent;
        private Map<String, Integer> remove;

        public DelFieldSelector(Map<String, Integer> remove) {
            this.remove = remove;
        }

        public void setParent(FieldSelector parent) {
            this.parent = parent;
        }

        public FieldSelectorResult accept(String fieldName) {
            if (!this.remove.isEmpty() && this.remove.containsKey(fieldName) && (this.remove.get(fieldName) & 2) > 0) {
                ++StorePruningPolicy.this.delFields;
                if (StorePruningPolicy.this.delFields % 10000 == 0) {
                    LOG.info(" - stored fields: removed " + StorePruningPolicy.this.delFields + " fields.");
                }
                return FieldSelectorResult.NO_LOAD;
            }
            if (this.parent != null) {
                return this.parent.accept(fieldName);
            }
            return FieldSelectorResult.LOAD;
        }
    }
}

