/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.pruning;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.PruningReader;
import org.apache.lucene.index.pruning.CarmelTopKTermPruningPolicy;
import org.apache.lucene.index.pruning.CarmelUniformTermPruningPolicy;
import org.apache.lucene.index.pruning.RIDFTermPruningPolicy;
import org.apache.lucene.index.pruning.StorePruningPolicy;
import org.apache.lucene.index.pruning.TFTermPruningPolicy;
import org.apache.lucene.index.pruning.TermPruningPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class PruningTool {
    public static void main(String[] args) throws Exception {
        int res = PruningTool.run(args);
        System.exit(res);
    }

    public static int run(String[] args) throws Exception {
        if (args.length < 5) {
            System.err.println("Usage: PruningTool -impl (tf | carmel | carmeltopk | ridf) (-in <path1> [-in <path2> ...]) -out <outPath> -t <NN> [-del f1,f2,..] [-conf <file>] [-topkk <NN>] [-topke <NN>] [-topkr <NN>]");
            System.err.println("\t-impl (tf | carmel | carmeltopk | ridf)\tTermPruningPolicy implementation name: TF or CarmelUniform or or CarmelTopK or RIDFTerm");
            System.err.println("\t-in path\tpath to the input index. Can specify multiple input indexes.");
            System.err.println("\t-out path\toutput path where the output index will be stored.");
            System.err.println("\t-t NN\tdefault threshold value (minimum in-document frequency) for all terms");
            System.err.println("\t-del f1,f2,..\tcomma-separated list of field specs to delete (postings, vectors & stored):");
            System.err.println("\t\tfield spec : fieldName ( ':' [pPsv] )");
            System.err.println("\t\twhere: p - postings, P - payloads, s - stored value, v - vectors");
            System.err.println("\t-conf file\tpath to config file with per-term thresholds");
            System.err.println("\t-topkk NN\t'K' for Carmel TopK Pruning: number of guaranteed top scores");
            System.err.println("\t-topke NN\t'Epsilon' for Carmel TopK Pruning: largest meaningless score difference");
            System.err.println("\t-topkr NN\t'R' for Carmel TopK Pruning: planned maximal number of terms in a query on pruned index");
            return -1;
        }
        ArrayList<IndexReader> inputs = new ArrayList<IndexReader>();
        FSDirectory out = null;
        float thr = -1.0f;
        HashMap<String, Integer> delFields = new HashMap<String, Integer>();
        int topkK = 10;
        float topkEpsilon = 0.001f;
        int topkR = 1;
        String impl = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-in")) {
                FSDirectory d;
                if (!IndexReader.indexExists((Directory)(d = FSDirectory.open((File)new File(args[++i]))))) {
                    System.err.println("WARN: no index in " + args[i] + ", skipping ...");
                }
                inputs.add(IndexReader.open((Directory)d, (boolean)true));
                continue;
            }
            if (args[i].equals("-out")) {
                File outFile;
                if ((outFile = new File(args[++i])).exists()) {
                    throw new Exception("Output " + outFile + " already exists.");
                }
                outFile.mkdirs();
                out = FSDirectory.open((File)outFile);
                continue;
            }
            if (args[i].equals("-impl")) {
                impl = args[++i];
                continue;
            }
            if (args[i].equals("-t")) {
                thr = Float.parseFloat(args[++i]);
                continue;
            }
            if (args[i].equals("-topkk")) {
                topkK = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-topke")) {
                topkEpsilon = Float.parseFloat(args[++i]);
                continue;
            }
            if (args[i].equals("-topkr")) {
                topkR = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-del")) {
                String[] fields;
                for (String f : fields = args[++i].split(",")) {
                    String[] spec = f.split(":");
                    int opts = 255;
                    if (spec.length > 0) {
                        opts = 0;
                        if (spec[1].indexOf(112) != -1) {
                            opts |= 1;
                        }
                        if (spec[1].indexOf(80) != -1) {
                            opts |= 8;
                        }
                        if (spec[1].indexOf(115) != -1) {
                            opts |= 2;
                        }
                        if (spec[1].indexOf(118) != -1) {
                            opts |= 4;
                        }
                    }
                    delFields.put(spec[0], opts);
                }
                continue;
            }
            if (args[i].equals("-conf")) {
                ++i;
                System.err.println("WARN: -conf option not implemented yet.");
                continue;
            }
            throw new Exception("Invalid argument: '" + args[i] + "'");
        }
        if (impl == null) {
            throw new Exception("Must select algorithm implementation");
        }
        if (inputs.size() == 0) {
            throw new Exception("At least one input index is required.");
        }
        if (out == null) {
            throw new Exception("Output path is not set.");
        }
        if (thr == -1.0f) {
            throw new Exception("Threshold value is not set.");
        }
        Object in = inputs.size() == 1 ? (IndexReader)inputs.get(0) : new MultiReader(inputs.toArray(new IndexReader[inputs.size()]), true);
        if (in.hasDeletions()) {
            System.err.println("WARN: input index(es) with deletions - document ID-s will NOT be preserved!");
        }
        PruningReader pruning = null;
        StorePruningPolicy stp = null;
        if (delFields.size() > 0) {
            stp = new StorePruningPolicy((IndexReader)in, (Map<String, Integer>)delFields);
        }
        TermPruningPolicy tpp = null;
        if (impl.equals("tf")) {
            tpp = new TFTermPruningPolicy((IndexReader)in, (Map<String, Integer>)delFields, null, (int)thr);
        } else if (impl.equals("carmel")) {
            tpp = new CarmelUniformTermPruningPolicy((IndexReader)in, (Map<String, Integer>)delFields, null, thr, null);
        } else if (impl.equals("carmeltopk")) {
            tpp = new CarmelTopKTermPruningPolicy((IndexReader)in, (Map<String, Integer>)delFields, topkK, topkEpsilon, topkR, null);
        } else if (impl.equals("ridf")) {
            tpp = new RIDFTermPruningPolicy((IndexReader)in, (Map<String, Integer>)delFields, null, thr);
        } else {
            throw new Exception("Unknown algorithm: '" + impl + "'");
        }
        pruning = new PruningReader((IndexReader)in, stp, tpp);
        IndexWriterConfig cfg = new IndexWriterConfig(Version.LUCENE_31, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_31));
        IndexWriter iw = new IndexWriter((Directory)out, cfg);
        iw.addIndexes(new IndexReader[]{pruning});
        iw.close();
        System.err.println("DONE.");
        return 0;
    }
}

