/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.pruning;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.pruning.TermPruningPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RIDFTermPruningPolicy
extends TermPruningPolicy {
    double defThreshold;
    Map<String, Double> thresholds;
    double idf;
    double maxDoc;
    double ridf;

    public RIDFTermPruningPolicy(IndexReader in, Map<String, Integer> fieldFlags, Map<String, Double> thresholds, double defThreshold) {
        super(in, fieldFlags);
        this.defThreshold = defThreshold;
        this.thresholds = thresholds != null ? thresholds : Collections.emptyMap();
        this.maxDoc = in.maxDoc();
    }

    @Override
    public void initPositionsTerm(TermPositions tp, Term t) throws IOException {
        this.idf = -Math.log((double)this.in.docFreq(t) / this.maxDoc);
        int totalFreq = 0;
        while (tp.next()) {
            totalFreq += tp.freq();
        }
        tp.seek(t);
        this.ridf = this.idf + Math.log(1.0 - Math.pow(Math.E, (double)(-totalFreq) / this.maxDoc));
    }

    @Override
    public boolean pruneTermEnum(TermEnum te) throws IOException {
        return false;
    }

    @Override
    public boolean pruneAllPositions(TermPositions termPositions, Term t) throws IOException {
        double thr = this.defThreshold;
        String key = t.field() + ":" + t.text();
        if (this.thresholds.containsKey(key)) {
            thr = this.thresholds.get(key);
        } else if (this.thresholds.containsKey(t.field())) {
            thr = this.thresholds.get(t.field());
        }
        return !(this.ridf > thr);
    }

    @Override
    public int pruneTermVectorTerms(int docNumber, String field, String[] terms, int[] freqs, TermFreqVector v) throws IOException {
        return 0;
    }

    @Override
    public int pruneSomePositions(int docNum, int[] positions, Term curTerm) {
        return 0;
    }
}

