/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.misc.HighFreqTerms;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;

public class GetTermInfo {
    public static void main(String[] args) throws Exception {
        FSDirectory dir = null;
        String inputStr = null;
        String field = null;
        if (args.length == 3) {
            dir = FSDirectory.open((File)new File(args[0]));
            field = args[1];
            inputStr = args[2];
        } else {
            GetTermInfo.usage();
            System.exit(1);
        }
        GetTermInfo.getTermInfo((Directory)dir, field, new BytesRef(inputStr));
    }

    public static void getTermInfo(Directory dir, String field, BytesRef termtext) throws Exception {
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        long totalTF = HighFreqTerms.getTotalTermFreq((IndexReader)reader, field, termtext);
        System.out.printf("%s:%s \t totalTF = %,d \t doc freq = %,d \n", field, termtext.utf8ToString(), totalTF, reader.docFreq(field, termtext));
    }

    private static void usage() {
        System.out.println("\n\nusage:\n\tjava " + GetTermInfo.class.getName() + " <index dir> field term \n\n");
    }
}

