/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.misc.TermInfo;
import org.apache.lucene.misc.TermInfoQueue;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class HighFreqTerms {
    public static final int numTerms = 100;

    public static void main(String[] args) throws Exception {
        IndexReader reader = null;
        FSDirectory dir = null;
        String field = null;
        if (args.length == 1) {
            dir = FSDirectory.open((File)new File(args[0]));
            reader = IndexReader.open((Directory)dir, (boolean)true);
        } else if (args.length == 2) {
            dir = FSDirectory.open((File)new File(args[0]));
            reader = IndexReader.open((Directory)dir, (boolean)true);
            field = args[1];
        } else {
            HighFreqTerms.usage();
            System.exit(1);
        }
        TermInfoQueue tiq = new TermInfoQueue(100);
        TermEnum terms = reader.terms();
        if (field != null) {
            while (terms.next()) {
                if (!terms.term().field().equals(field)) continue;
                tiq.insertWithOverflow(new TermInfo(terms.term(), terms.docFreq()));
            }
        } else {
            while (terms.next()) {
                tiq.insertWithOverflow(new TermInfo(terms.term(), terms.docFreq()));
            }
        }
        while (tiq.size() != 0) {
            TermInfo termInfo = (TermInfo)tiq.pop();
            System.out.println(termInfo.term + " " + termInfo.docFreq);
        }
        reader.close();
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [field]\n\n");
    }
}

