/*
 * Decompiled with CFR 0.152.
 */
package lucli;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import jline.ConsoleReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;

class LuceneMethods {
    private int numDocs;
    private String indexName;
    Iterator fieldIterator;
    Vector fields;
    Vector indexedFields;
    String[] fieldsArray;
    Searcher searcher;
    Query query;

    public LuceneMethods(String index) {
        this.indexName = index;
        LuceneMethods.message("Lucene CLI. Using directory '" + this.indexName + "'. Type 'help' for instructions.");
    }

    public void info() throws IOException {
        IndexReader indexReader = IndexReader.open((String)this.indexName);
        this.getFieldInfo();
        this.numDocs = indexReader.numDocs();
        LuceneMethods.message("Index has " + this.numDocs + " documents ");
        LuceneMethods.message("All Fields:" + this.fields.toString());
        LuceneMethods.message("Indexed Fields:" + this.indexedFields.toString());
        if (IndexReader.isLocked((String)this.indexName)) {
            LuceneMethods.message("Index is locked");
        }
        indexReader.close();
    }

    public void search(String queryString, boolean explain, boolean showTokens, ConsoleReader cr) throws IOException, ParseException {
        Hits hits = this.initSearch(queryString);
        System.out.println(hits.length() + " total matching documents");
        if (explain) {
            this.query = this.explainQuery(queryString);
        }
        int HITS_PER_PAGE = 10;
        LuceneMethods.message("--------------------------------------");
        for (int start = 0; start < hits.length(); start += 10) {
            int end = Math.min(hits.length(), start + 10);
            for (int ii = start; ii < end; ++ii) {
                Document doc = hits.doc(ii);
                LuceneMethods.message("---------------- " + (ii + 1) + " score:" + hits.score(ii) + "---------------------");
                this.printHit(doc);
                if (showTokens) {
                    this.invertDocument(doc);
                }
                if (!explain) continue;
                Explanation exp = this.searcher.explain(this.query, hits.id(ii));
                LuceneMethods.message("Explanation:" + exp.toString());
            }
            LuceneMethods.message("#################################################");
            if (hits.length() > end && ((queryString = cr.readLine("more (y/n) ? ")).length() == 0 || queryString.charAt(0) == 'n')) break;
        }
        this.searcher.close();
    }

    private void printHit(Document doc) {
        for (int ii = 0; ii < this.fieldsArray.length; ++ii) {
            String currField = this.fieldsArray[ii];
            String[] result = doc.getValues(currField);
            if (result != null) {
                for (int i = 0; i < result.length; ++i) {
                    LuceneMethods.message(currField + ":" + result[i]);
                }
                continue;
            }
            LuceneMethods.message(currField + ": <not available>");
        }
    }

    public void optimize() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexName, (Analyzer)new StandardAnalyzer(), false);
        LuceneMethods.message("Starting to optimize index.");
        long start = System.currentTimeMillis();
        indexWriter.optimize();
        LuceneMethods.message("Done optimizing index. Took " + (System.currentTimeMillis() - start) + " msecs");
        indexWriter.close();
    }

    private Query explainQuery(String queryString) throws IOException, ParseException {
        this.searcher = new IndexSearcher(this.indexName);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        this.getFieldInfo();
        MultiFieldQueryParser parser = new MultiFieldQueryParser(queryString, (Analyzer)analyzer);
        int arraySize = this.indexedFields.size();
        String[] indexedArray = new String[arraySize];
        for (int ii = 0; ii < arraySize; ++ii) {
            indexedArray[ii] = (String)this.indexedFields.get(ii);
        }
        this.query = MultiFieldQueryParser.parse((String)queryString, (String[])indexedArray, (Analyzer)analyzer);
        System.out.println("Searching for: " + this.query.toString());
        return this.query;
    }

    private Hits initSearch(String queryString) throws IOException, ParseException {
        this.searcher = new IndexSearcher(this.indexName);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        this.getFieldInfo();
        MultiFieldQueryParser parser = new MultiFieldQueryParser(queryString, (Analyzer)analyzer);
        int arraySize = this.fields.size();
        this.fieldsArray = new String[arraySize];
        for (int ii = 0; ii < arraySize; ++ii) {
            this.fieldsArray[ii] = (String)this.fields.get(ii);
        }
        this.query = MultiFieldQueryParser.parse((String)queryString, (String[])this.fieldsArray, (Analyzer)analyzer);
        System.out.println("Searching for: " + this.query.toString());
        Hits hits = this.searcher.search(this.query);
        return hits;
    }

    public void count(String queryString) throws IOException, ParseException {
        Hits hits = this.initSearch(queryString);
        System.out.println(hits.length() + " total documents");
        this.searcher.close();
    }

    public static void message(String s) {
        System.out.println(s);
    }

    private void getFieldInfo() throws IOException {
        Object field;
        IndexReader indexReader = IndexReader.open((String)this.indexName);
        this.fields = new Vector();
        this.indexedFields = new Vector();
        this.fieldIterator = indexReader.getFieldNames().iterator();
        while (this.fieldIterator.hasNext()) {
            field = this.fieldIterator.next();
            if (field == null || field.equals("")) continue;
            this.fields.add(field.toString());
        }
        this.fieldIterator = indexReader.getFieldNames(true).iterator();
        while (this.fieldIterator.hasNext()) {
            field = this.fieldIterator.next();
            if (field == null || field.equals("")) continue;
            this.indexedFields.add(field.toString());
        }
        indexReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invertDocument(Document doc) throws IOException {
        Hashtable<String, Integer> tokenHash = new Hashtable<String, Integer>();
        int maxFieldLength = 10000;
        StandardAnalyzer analyzer = new StandardAnalyzer();
        Enumeration fields = doc.fields();
        block3: while (fields.hasMoreElements()) {
            Reader reader;
            Field field = (Field)fields.nextElement();
            String fieldName = field.name();
            if (!field.isIndexed() || !field.isTokenized()) continue;
            if (field.readerValue() != null) {
                reader = field.readerValue();
            } else if (field.stringValue() != null) {
                reader = new StringReader(field.stringValue());
            } else {
                throw new IllegalArgumentException("field must have either String or Reader value");
            }
            int position = 0;
            TokenStream stream = analyzer.tokenStream(fieldName, reader);
            try {
                Token t = stream.next();
                while (t != null) {
                    position += t.getPositionIncrement() - 1;
                    ++position;
                    String name = t.termText();
                    Integer Count = (Integer)tokenHash.get(name);
                    if (Count == null) {
                        tokenHash.put(name, new Integer(1));
                    } else {
                        int count = Count;
                        tokenHash.put(name, new Integer(count + 1));
                    }
                    if (position > 10000) continue block3;
                    t = stream.next();
                }
            }
            finally {
                stream.close();
            }
        }
        Map.Entry[] sortedHash = LuceneMethods.getSortedHashtableEntries(tokenHash);
        for (int ii = 0; ii < sortedHash.length && ii < 10; ++ii) {
            Map.Entry currentEntry = sortedHash[ii];
            LuceneMethods.message(ii + 1 + ":" + currentEntry.getKey() + " " + currentEntry.getValue());
        }
    }

    public void terms(String field) throws IOException {
        TreeMap<String, Integer> termMap = new TreeMap<String, Integer>();
        IndexReader indexReader = IndexReader.open((String)this.indexName);
        TermEnum terms = indexReader.terms();
        while (terms.next()) {
            Term term = terms.term();
            if (field != null && !field.equals(term.field())) continue;
            termMap.put(term.field() + ":" + term.text(), new Integer(terms.docFreq()));
        }
        Iterator termIterator = termMap.keySet().iterator();
        for (int ii = 0; termIterator.hasNext() && ii < 100; ++ii) {
            String termDetails = (String)termIterator.next();
            Integer termFreq = (Integer)termMap.get(termDetails);
            LuceneMethods.message(termDetails + ": " + termFreq);
        }
        indexReader.close();
    }

    public static Map.Entry[] getSortedHashtableEntries(Hashtable h) {
        Set set = h.entrySet();
        Map.Entry[] entries = set.toArray(new Map.Entry[set.size()]);
        Arrays.sort(entries, new Comparator(){

            public int compare(Object o1, Object o2) {
                Object v1 = ((Map.Entry)o1).getValue();
                Object v2 = ((Map.Entry)o2).getValue();
                return ((Comparable)v2).compareTo(v1);
            }
        });
        return entries;
    }
}

