/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocTermOrds;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsWithScoreCollector
extends Collector {
    private static final int INITIAL_ARRAY_SIZE = 256;
    final String field;
    final BytesRefHash collectedTerms = new BytesRefHash();
    final ScoreMode scoreMode;
    Scorer scorer;
    float[] scoreSums = new float[256];

    TermsWithScoreCollector(String field, ScoreMode scoreMode) {
        this.field = field;
        this.scoreMode = scoreMode;
    }

    public BytesRefHash getCollectedTerms() {
        return this.collectedTerms;
    }

    public float[] getScoresPerTerm() {
        return this.scoreSums;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    static TermsWithScoreCollector create(String field, boolean multipleValuesPerDocument, ScoreMode scoreMode) {
        if (multipleValuesPerDocument) {
            switch (scoreMode) {
                case Avg: {
                    return new MV.Avg(field);
                }
            }
            return new MV(field, scoreMode);
        }
        switch (scoreMode) {
            case Avg: {
                return new SV.Avg(field);
            }
        }
        return new SV(field, scoreMode);
    }

    static class MV
    extends TermsWithScoreCollector {
        DocTermOrds fromDocTermOrds;
        TermsEnum docTermsEnum;
        DocTermOrds.TermOrdsIterator reuse;

        MV(String field, ScoreMode scoreMode) {
            super(field, scoreMode);
        }

        public void collect(int doc) throws IOException {
            int chunk;
            this.reuse = this.fromDocTermOrds.lookup(doc, this.reuse);
            int[] buffer = new int[5];
            do {
                if ((chunk = this.reuse.read(buffer)) == 0) {
                    return;
                }
                block5: for (int idx = 0; idx < chunk; ++idx) {
                    int key = buffer[idx];
                    this.docTermsEnum.seekExact((long)key);
                    int ord = this.collectedTerms.add(this.docTermsEnum.term());
                    if (ord < 0) {
                        ord = -ord - 1;
                    } else if (ord >= this.scoreSums.length) {
                        this.scoreSums = ArrayUtil.grow((float[])this.scoreSums);
                    }
                    float current = this.scorer.score();
                    float existing = this.scoreSums[ord];
                    if (Float.compare(existing, 0.0f) == 0) {
                        this.scoreSums[ord] = current;
                        continue;
                    }
                    switch (this.scoreMode) {
                        case Total: {
                            this.scoreSums[ord] = existing + current;
                            continue block5;
                        }
                        case Max: {
                            if (!(current > existing)) continue block5;
                            this.scoreSums[ord] = current;
                        }
                    }
                }
            } while (chunk >= buffer.length);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.fromDocTermOrds = FieldCache.DEFAULT.getDocTermOrds(context.reader(), this.field);
            this.docTermsEnum = this.fromDocTermOrds.getOrdTermsEnum(context.reader());
            this.reuse = null;
        }

        static class Avg
        extends MV {
            int[] scoreCounts = new int[256];

            Avg(String field) {
                super(field, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                int chunk;
                this.reuse = this.fromDocTermOrds.lookup(doc, this.reuse);
                int[] buffer = new int[5];
                do {
                    if ((chunk = this.reuse.read(buffer)) == 0) {
                        return;
                    }
                    for (int idx = 0; idx < chunk; ++idx) {
                        int key = buffer[idx];
                        this.docTermsEnum.seekExact((long)key);
                        int ord = this.collectedTerms.add(this.docTermsEnum.term());
                        if (ord < 0) {
                            ord = -ord - 1;
                        } else if (ord >= this.scoreSums.length) {
                            this.scoreSums = ArrayUtil.grow((float[])this.scoreSums);
                            this.scoreCounts = ArrayUtil.grow((int[])this.scoreCounts);
                        }
                        float current = this.scorer.score();
                        float existing = this.scoreSums[ord];
                        if (Float.compare(existing, 0.0f) == 0) {
                            this.scoreSums[ord] = current;
                            this.scoreCounts[ord] = 1;
                            continue;
                        }
                        this.scoreSums[ord] = this.scoreSums[ord] + current;
                        int n = ord;
                        this.scoreCounts[n] = this.scoreCounts[n] + 1;
                    }
                } while (chunk >= buffer.length);
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }

    static class SV
    extends TermsWithScoreCollector {
        final BytesRef spare = new BytesRef();
        FieldCache.DocTerms fromDocTerms;

        SV(String field, ScoreMode scoreMode) {
            super(field, scoreMode);
        }

        public void collect(int doc) throws IOException {
            int ord = this.collectedTerms.add(this.fromDocTerms.getTerm(doc, this.spare));
            if (ord < 0) {
                ord = -ord - 1;
            } else if (ord >= this.scoreSums.length) {
                this.scoreSums = ArrayUtil.grow((float[])this.scoreSums);
            }
            float current = this.scorer.score();
            float existing = this.scoreSums[ord];
            if (Float.compare(existing, 0.0f) == 0) {
                this.scoreSums[ord] = current;
            } else {
                switch (this.scoreMode) {
                    case Total: {
                        this.scoreSums[ord] = this.scoreSums[ord] + current;
                        break;
                    }
                    case Max: {
                        if (!(current > existing)) break;
                        this.scoreSums[ord] = current;
                    }
                }
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.fromDocTerms = FieldCache.DEFAULT.getTerms(context.reader(), this.field);
        }

        static class Avg
        extends SV {
            int[] scoreCounts = new int[256];

            Avg(String field) {
                super(field, ScoreMode.Avg);
            }

            @Override
            public void collect(int doc) throws IOException {
                int ord = this.collectedTerms.add(this.fromDocTerms.getTerm(doc, this.spare));
                if (ord < 0) {
                    ord = -ord - 1;
                } else if (ord >= this.scoreSums.length) {
                    this.scoreSums = ArrayUtil.grow((float[])this.scoreSums);
                    this.scoreCounts = ArrayUtil.grow((int[])this.scoreCounts);
                }
                float current = this.scorer.score();
                float existing = this.scoreSums[ord];
                if (Float.compare(existing, 0.0f) == 0) {
                    this.scoreSums[ord] = current;
                    this.scoreCounts[ord] = 1;
                } else {
                    this.scoreSums[ord] = this.scoreSums[ord] + current;
                    int n = ord;
                    this.scoreCounts[n] = this.scoreCounts[n] + 1;
                }
            }

            @Override
            public float[] getScoresPerTerm() {
                if (this.scoreCounts != null) {
                    for (int i = 0; i < this.scoreCounts.length; ++i) {
                        this.scoreSums[i] = this.scoreSums[i] / (float)this.scoreCounts[i];
                    }
                    this.scoreCounts = null;
                }
                return this.scoreSums;
            }
        }
    }
}

