/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocTermOrds;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsCollector
extends Collector {
    final String field;
    final BytesRefHash collectorTerms = new BytesRefHash();

    TermsCollector(String field) {
        this.field = field;
    }

    public BytesRefHash getCollectorTerms() {
        return this.collectorTerms;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    static TermsCollector create(String field, boolean multipleValuesPerDocument) {
        return multipleValuesPerDocument ? new MV(field) : new SV(field);
    }

    static class SV
    extends TermsCollector {
        final BytesRef spare = new BytesRef();
        private FieldCache.DocTerms fromDocTerms;

        SV(String field) {
            super(field);
        }

        public void collect(int doc) throws IOException {
            this.collectorTerms.add(this.fromDocTerms.getTerm(doc, this.spare));
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.fromDocTerms = FieldCache.DEFAULT.getTerms(context.reader(), this.field);
        }
    }

    static class MV
    extends TermsCollector {
        private DocTermOrds docTermOrds;
        private TermsEnum docTermsEnum;
        private DocTermOrds.TermOrdsIterator reuse;

        MV(String field) {
            super(field);
        }

        public void collect(int doc) throws IOException {
            int chunk;
            this.reuse = this.docTermOrds.lookup(doc, this.reuse);
            int[] buffer = new int[5];
            do {
                if ((chunk = this.reuse.read(buffer)) == 0) {
                    return;
                }
                for (int idx = 0; idx < chunk; ++idx) {
                    int key = buffer[idx];
                    this.docTermsEnum.seekExact((long)key);
                    this.collectorTerms.add(this.docTermsEnum.term());
                }
            } while (chunk >= buffer.length);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.docTermOrds = FieldCache.DEFAULT.getDocTermOrds(context.reader(), this.field);
            this.docTermsEnum = this.docTermOrds.getOrdTermsEnum(context.reader());
            this.reuse = null;
        }
    }
}

