/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public class ToChildBlockJoinQuery
extends Query {
    private final Filter parentsFilter;
    private final Query parentQuery;
    private final Query origParentQuery;
    private final boolean doScores;

    public ToChildBlockJoinQuery(Query parentQuery, Filter parentsFilter, boolean doScores) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    private ToChildBlockJoinQuery(Query origParentQuery, Query parentQuery, Filter parentsFilter, boolean doScores) {
        this.origParentQuery = origParentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher), this.parentsFilter, this.doScores);
    }

    public void extractTerms(Set<Term> terms) {
        this.parentQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            ToChildBlockJoinQuery rewritten = new ToChildBlockJoinQuery(this.parentQuery, parentRewrite, this.parentsFilter, this.doScores);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof ToChildBlockJoinQuery) {
            ToChildBlockJoinQuery other = (ToChildBlockJoinQuery)((Object)_other);
            return this.origParentQuery.equals((Object)other.origParentQuery) && this.parentsFilter.equals(other.parentsFilter) && this.doScores == other.doScores;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + new Boolean(this.doScores).hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    public ToChildBlockJoinQuery clone() {
        return new ToChildBlockJoinQuery(this.origParentQuery.clone(), this.parentsFilter, this.doScores);
    }

    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final FixedBitSet parentBits;
        private final boolean doScores;
        private final Bits acceptDocs;
        private float parentScore;
        private float parentFreq = 1.0f;
        private int childDoc = -1;
        private int parentDoc;

        public ToChildBlockJoinScorer(Weight weight, Scorer parentScorer, FixedBitSet parentBits, boolean doScores, Bits acceptDocs) {
            super(weight);
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
            this.acceptDocs = acceptDocs;
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.parentScorer, "BLOCK_JOIN"));
        }

        /*
         * Unable to fully structure code
         */
        public int nextDoc() throws IOException {
            do lbl-1000:
            // 3 sources

            {
                block6: {
                    if (this.childDoc + 1 != this.parentDoc) break block6;
                    do {
                        this.parentDoc = this.parentScorer.nextDoc();
                        if (this.parentDoc == 0) {
                            this.parentDoc = this.parentScorer.nextDoc();
                        }
                        if (this.parentDoc == 0x7FFFFFFF) {
                            this.childDoc = 0x7FFFFFFF;
                            return this.childDoc;
                        }
                        this.childDoc = 1 + this.parentBits.prevSetBit(this.parentDoc - 1);
                        if (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc)) ** GOTO lbl-1000
                    } while (this.childDoc >= this.parentDoc);
                    if (this.doScores) {
                        this.parentScore = this.parentScorer.score();
                        this.parentFreq = this.parentScorer.freq();
                    }
                    return this.childDoc;
                }
                if (!ToChildBlockJoinScorer.$assertionsDisabled && this.childDoc >= this.parentDoc) {
                    throw new AssertionError((Object)("childDoc=" + this.childDoc + " parentDoc=" + this.parentDoc));
                }
                ++this.childDoc;
            } while (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc));
            return this.childDoc;
        }

        public int docID() {
            return this.childDoc;
        }

        public float score() throws IOException {
            return this.parentScore;
        }

        public float freq() throws IOException {
            return this.parentFreq;
        }

        public int advance(int childTarget) throws IOException {
            assert (childTarget >= this.parentBits.length() || !this.parentBits.get(childTarget));
            if (childTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                this.childDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            assert (this.childDoc == -1 || childTarget != this.parentDoc) : "childTarget=" + childTarget;
            if (this.childDoc == -1 || childTarget > this.parentDoc) {
                this.parentDoc = this.parentScorer.advance(childTarget);
                assert (this.parentDoc > childTarget);
                if (this.parentDoc == Integer.MAX_VALUE) {
                    this.childDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.doScores) {
                    this.parentScore = this.parentScorer.score();
                    this.parentFreq = this.parentScorer.freq();
                }
                int firstChild = this.parentBits.prevSetBit(this.parentDoc - 1);
                childTarget = Math.max(childTarget, firstChild);
            }
            assert (childTarget < this.parentDoc);
            this.childDoc = childTarget;
            if (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc)) {
                this.nextDoc();
            }
            return this.childDoc;
        }
    }

    private static class ToChildBlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight parentWeight;
        private final Filter parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, Filter parentsFilter, boolean doScores) {
            this.joinQuery = joinQuery;
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        public Query getQuery() {
            return this.joinQuery;
        }

        public float getValueForNormalization() throws IOException {
            return this.parentWeight.getValueForNormalization() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.parentWeight.normalize(norm, topLevelBoost * this.joinQuery.getBoost());
        }

        public Scorer scorer(AtomicReaderContext readerContext, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(readerContext, true, false, null);
            if (parentScorer == null) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(readerContext, null);
            if (parents == null) {
                return null;
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
            }
            return new ToChildBlockJoinScorer(this, parentScorer, (FixedBitSet)parents, this.doScores, acceptDocs);
        }

        public Explanation explain(AtomicReaderContext reader, int doc) throws IOException {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot explain match on parent document");
        }

        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

